% Example for alg. 11.9  "An introduction to 3-D Vision"
% by Y. Ma, S. Soatto, J. Kosecka, S. Sastry (MASKS)
% Code distributed free for non-commercial use
% Copyright (c) MASKS, 2003

% Projective rectification example
% Given fundamental matrix between two views compute 
% warping homographies H1, H2 for both views.
% See step-by-step.m for use in an example.
% May 2003, Jana Kosecka, George Mason University
% ================================================

[H1, H2] = projRectify(F,x1, x2, xdim, ydim)
 Tr = [1 0 -xdim/2; 0 1 -ydim/2 ; 0 0 1]; 
 H1 = inv(Tr)*H1;
 H2 = inv(Tr)*H2;
 xim1r = project(H1*x1);
 xim2r = project(H2*x2);
 [im0w, xi0, yi0] = Hwarp(H1, im0); 
 [im1w, xi1, yi1] = Hwarp(H2, im1);
 imagesc(im0w); colormap gray; hold on; axis image;
 imagesc(im1w); colormap gray; hold on; axis image;
 
