/*
	Copyright (C) 1994 Sean Luke

	COWSExampleLibrary.m
	Version 1.0
	Sean Luke
	
*/




#import "COWSExampleLibrary.h"

@implementation COWSExampleLibrary

- loadLibrary:sender
	{
	id returnval=[super loadLibrary:sender];
	
	if (![sender conformsTo:@protocol(LibraryControl)])
		{
		printf ("StandardLibrary error:  Interpreter cannot accept Library Control protocol!\n");
		return NULL;
		}
		
		[sender addLibraryFunction:"scroll-value"
			selector:@selector(scrollValue:)
			target:self];
	
		[sender addLibraryFunction:"set-scroll-value"
			selector:@selector(setScrollValue:)
			target:self];
	
		[sender addLibraryFunction:"check-value"
			selector:@selector(checkValue:)
			target:self];
	
		[sender addLibraryFunction:"set-check-value"
			selector:@selector(setCheckValue:)
			target:self];
	
		[sender addLibraryFunction:"radio-value"
			selector:@selector(radioValue:)
			target:self];
	
		[sender addLibraryFunction:"select-radio-value"
			selector:@selector(setRadioValue:)
			target:self];
	
		[sender addLibraryFunction:"press-button"
			selector:@selector(pressButton:)
			target:self];
	
		[sender addLibraryFunction:"set-string-value"
			selector:@selector(setStringValue:)
			target:self];
	
		[sender addLibraryFunction:"string-value"
			selector:@selector(stringValue:)
			target:self];
	
		[sender addLibraryFunction:"set-window-position"
			selector:@selector(setWindowPosition:)
			target:self];
	
		[sender addLibraryFunction:"window-x-position"
			selector:@selector(windowXPosition:)
			target:self];
	
		[sender addLibraryFunction:"window-y-position"
			selector:@selector(windowYPosition:)
			target:self];
	
		[sender addLibraryFunction:"window-title"
			selector:@selector(windowTitle:)
			target:self];
	
		[sender addLibraryFunction:"set-window-title"
			selector:@selector(setWindowTitle:)
			target:self];
			
		[sender addLibraryFunction:"ping"
			selector:@selector(ping:)
			target:self];
			
	return returnval;
	}
	
	
- scrollValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	char buf[COWSLARGENUMBER];
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	sprintf(buf,"%f",
		[[scroll cellAt:0:[item intVal]] floatValue]);
	[item free];
	
	[returnval setString:buf];
	return returnval;
	}
	
	
- setScrollValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item,value;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	if ([arg_list top]==NULL) 				// just one arg
		{
		[returnval setBooleanVal:NO];
		[item free];
		return returnval;
		}

	value=[arg_list pop]; 
	
	[[scroll cellAt:0:[item intVal]] 
		setFloatValue:[value floatVal]];
	[item free];
	[value free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}
	

- checkValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	BOOL x;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	x=(BOOL)[[check cellAt:[item intVal]:0] state];
	[item free];
	
	[returnval setBooleanVal:(x ? YES : NO)];
	return returnval;
	}
	

- setCheckValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item,value;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	if ([arg_list top]==NULL) 				// just one arg
		{
		[returnval setBooleanVal:NO];
		[item free];
		return returnval;
		}

	value=[arg_list pop]; 
	
	[[check cellAt:[item intVal]:0] 
		setIntValue:[value booleanVal] ? 1 : 0];
	[item free];
	[value free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}
	

- radioValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	BOOL x;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	x=(BOOL)[[radio cellAt:[item intVal]:0] floatValue];
	[item free];
	
	[returnval setBooleanVal:(x ? YES : NO)];
	return returnval;
	}
	

- setRadioValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	[radio selectCellAt:[item intVal]:0];
	[item free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}
	

- pressButton:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	[[button cellAt:[item intVal]:0] performClick:self];
	[item free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}
	

- setStringValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item,value;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	if ([arg_list top]==NULL) 				// just one arg
		{
		[returnval setBooleanVal:NO];
		[item free];
		return returnval;
		}

	value=[arg_list pop]; 
	
	[[field cellAt:[item intVal]:0] 
		setStringValue:[value string]];
	[item free];
	[value free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}
	

- stringValue:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	[returnval setString:
		[[field cellAt:[item intVal]:0] stringValue]];
	[item free];
	
	return returnval;
	}
	

- setWindowPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item,value;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	if ([arg_list top]==NULL) 				// just one arg
		{
		[returnval setBooleanVal:NO];
		[item free];
		return returnval;
		}

	value=[arg_list pop]; 
	
	[window moveTo:[item floatVal]:[value floatVal]];
	[item free];
	[value free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}
	

- windowXPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	char buf[COWSLARGENUMBER];
	NXRect rect;
	
	[window getFrame:&rect];
	sprintf(buf,"%f",rect.origin.x);
	[returnval setString:buf];
	return returnval;
	}
	

- windowYPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	char buf[COWSLARGENUMBER];
	NXRect rect;
	
	[window getFrame:&rect];
	sprintf(buf,"%f",rect.origin.y);
	[returnval setString:buf];
	return returnval;
	}
	

- windowTitle:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	
	[returnval setString:[window title]];
	return returnval;
	}
	

- setWindowTitle:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	[window setTitle:[item string]];
	[item free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}

- ping:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	NXPing();
	[returnval setBooleanVal:YES];
	return returnval;
	}


		
@end