/* 	

	Fred 

	Implementation

	Created:  		November 1991
	Last Edited:	March 1994
	
	Sean Luke
	
*/


#import "FredLibrary.h"


@implementation FredLibrary

- appDidInit:sender
{
	thisWindow=[NXApp appIcon];
	/*if (userController)
		if ([userController respondsTo:@selector(appDidInit:)])
			[userController appDidInit:sender];*/
	return self;
}


- loadLibrary:sender
	{
	id returnval=[super loadLibrary:sender];
	
	if (![sender conformsTo:@protocol(LibraryControl)])
		{
		printf ("Fred error:  Interpreter cannot accept Library Control protocol!\n");
		return NULL;
		}
		
		[sender addLibraryFunction:"icon-x"
			selector:@selector(fred_iconXPosition:)
			target:self];
	
		[sender addLibraryFunction:"icon-y"
			selector:@selector(fred_iconYPosition:)
			target:self];
	
		[sender addLibraryFunction:"mouse-x"
			selector:@selector(fred_mouseXPosition:)
			target:self];
	
		[sender addLibraryFunction:"mouse-y"
			selector:@selector(fred_mouseYPosition:)
			target:self];
	
		[sender addLibraryFunction:"move-icon"
			selector:@selector(fred_moveIcon:)
			target:self];
	
	return returnval;
	}
	
- pauseCancelled:sender
	{
	return self;
	}

- fred_iconXPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	char buf[COWSLARGENUMBER];
	NXRect rect;
	
	[thisWindow getFrame:&rect];
	sprintf(buf,"%f",rect.origin.x);
	[returnval setString:buf];
	return returnval;
	}


- fred_iconYPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	char buf[COWSLARGENUMBER];
	NXRect rect;
	
	[thisWindow getFrame:&rect];
	sprintf(buf,"%f",rect.origin.y);
	[returnval setString:buf];
	return returnval;
	}


- fred_mouseXPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	char buf[COWSLARGENUMBER];
	NXPoint point;
	
	[thisWindow getMouseLocation:&point];
	sprintf(buf,"%f",point.x);
	[returnval setString:buf];
	return returnval;
	}
	

- fred_mouseYPosition:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	char buf[COWSLARGENUMBER];
	NXPoint point;
	
	[thisWindow getMouseLocation:&point];
	sprintf(buf,"%f",point.y);
	[returnval setString:buf];
	return returnval;
	}


- fred_moveIcon:arg_list
	{
	id returnval=[[COWSStringNode alloc] init];
	id item,value;
	
	if ([arg_list top]==NULL) 				// no args
		{
		[returnval setBooleanVal:NO];
		return returnval;
		}
	
	item=[arg_list pop];
	
	if ([arg_list top]==NULL) 				// just one arg
		{
		[returnval setBooleanVal:NO];
		[item free];
		return returnval;
		}

	value=[arg_list pop]; 
	
	[thisWindow moveTo:[item floatVal]:[value floatVal]];
	[item free];
	[value free];
	
	[returnval setBooleanVal:YES];
	return returnval;
	}

@end