#import "Controller.h"
#import <appkit/appkit.h>
#import <sys/file.h>

@implementation Controller

- init
	{
	id returnval=[super init];
	journaler=[[NXJournaler alloc] init];
	[journaler setDelegate:self];
	[NXApp setDelegate:self];
	return returnval;
	}

- (int) status
	{
	return status;
	}

- play:sender
{
	char const*filetype[2]={0,0};
   	id op=[OpenPanel new];
    const char* fi;
	id result;
	
	if (status) 
		{
		if (status==MAC_STATUS_PLAYING) [play_button setState:1];
		if (status==MAC_STATUS_RECORDING) [play_button setState:0];
		[op free];
		return NULL;
		}
	
	[play_button setState:1];
	status=MAC_STATUS_PLAYING;
	filetype[0]="mac";
	[op allowMultipleFiles:NO];
	[op setPrompt: "Macro to Play:"];
	[op runModalForDirectory:NXHomeDirectory() file: "" types:filetype];
	fi=[op filename];
	result=[self playFile:fi];	
	[op free];
	return result;
}	

	
- playFile:(const char*) fi
	{
	if (fi==NULL)
		{
		status=MAC_STATUS_STOPPED;
		[play_button setState:0];
		return NULL;
		}
	fd=open (fi,O_RDONLY,0666);		// read, write by anyone
	if (fd==-1)
		{
		status=MAC_STATUS_STOPPED;
		[play_button setState:0];
		return NULL;
		}
		
	current=NXOpenFile(fd,NX_READONLY);
	[journaler setEventStatus:NX_PLAYING
			soundStatus:NX_STOPPED
			eventStream:current
			soundfile:NULL];
    return self;
}

- record:sender
{
	char const*filetype[2]={0,0};
   	id sp=[SavePanel new];
    const char* fi;
	int result;
	
	if (status) 
		{
		if (status==MAC_STATUS_PLAYING) [record_button setState:0];
		if (status==MAC_STATUS_RECORDING) [record_button setState:1];
		[sp free];
		return NULL;
		}
	
	[record_button setState:1];
	status=MAC_STATUS_RECORDING;
	filetype[0]="mac";
	[sp setRequiredFileType:"mac"];
	[sp setPrompt: "Save Macro as:"];
	result=[sp runModalForDirectory:NXHomeDirectory() file: ""];
	fi=[sp filename];
	
	if (fi==NULL)
		{
		status=MAC_STATUS_STOPPED;
		[record_button setState:0];
		[sp free];
		return NULL;
		}
	fd=open (fi,O_WRONLY|O_CREAT,0666);		// read, write by anyone
	if (fd==-1)
		{
		status=MAC_STATUS_STOPPED;
		[record_button setState:0];
		[sp free];
		return NULL;
		}
		
	current=NXOpenFile(fd,NX_WRITEONLY);
	[journaler setEventStatus:NX_RECORDING
			soundStatus:NX_STOPPED
			eventStream:current
			soundfile:NULL];
	[sp free];
    return self;
}

- stop:sender
{
	if (status==MAC_STATUS_STOPPED) 
		{
		[stop_button setState:0];
		return NULL;
		}
	[journaler setEventStatus:NX_STOPPED
			soundStatus:NX_STOPPED
			eventStream:current
			soundfile:NULL];
    return self;
} 


- journalerDidEnd:this_journaler
{
	NXClose(current);
	close(fd);
	status=MAC_STATUS_STOPPED;
	[play_button setState:0];
	[record_button setState:0];
	[stop_button setState:0];
	[functionLibrary journalerDidEnd:this_journaler];
	return self;
}

- journalerDidUserAbort:journaler
{
	return self;
}

- (BOOL) appAcceptsAnotherFile:sender
{
	return (status==MAC_STATUS_STOPPED);	
							// can only accept file in stopped state
}

- (int) app:sender openFile:(const char*) filename type:(const char*) aType
{
	return ([self playFile:filename]!=NULL);
}

@end
