/*
	Copyright (C) 1994 Sean Luke

	FunctionLibrary.m
	Version 1.3
	Sean Luke
	
*/




#import "FunctionLibrary.h"
#import "PAStringList.h"

@implementation FunctionLibrary


- init
	{
	paused=NO;
	return [super init];
	}
	
- loadLibrary:sender
	{
	[super loadLibrary:sender];
	[sender addLibraryFunction:"play"
			selector:@selector(function_play:)
			target:self];
	interpreter=sender;
	return self;
	}
	
- pauseCancelled:sender
	{
	return self;
	}
	
- function_play:arg_list
	{
	id return_val=[[COWSStringNode alloc] init];
	id tempStringList;
	id fileNameList;
	id filename;
	const char* file;
	char** strings;
	char** filenames;
	int x, count, found;

	printf ("Playing\n");
	if ([controller status]!=MAC_STATUS_STOPPED)
		{
		[return_val setString:"Mac error:  already working!"];
		[return_val setError:YES];
		return return_val;
		}
	
	// get requested file name
	
	filename=[arg_list pop];
	if (filename==NULL)
		{
		[return_val setString: "Mac error:  nothing to play!"];
		[return_val setError:YES];
		return return_val;
		}
	
	file=[filename string];
		
	tempStringList=[[PAStringList alloc] init];
	fileNameList=[[PAStringList alloc] init];
		
	// Get files in App Wrapper
	[tempStringList 
		addFilenamesFromDirectory:[[NXBundle mainBundle] directory] 
		withExt:"mac" stripPath: NO stripExt: NO 
		ifAbsent: YES sorted: NO at: 0];
	[fileNameList 
		addFilenamesFromDirectory:[[NXBundle mainBundle] directory] 
		withExt:"mac" stripPath: YES stripExt: YES 
		ifAbsent: YES sorted: NO at: 0];
	
	// Get files from Libraries
	[tempStringList 
		addFilenamesFromStandardLibrariesDirectory: "Mac" 
		withExt:"mac" stripPath: NO stripExt: NO 
		ifAbsent: YES sorted: NO at: 0];
	[fileNameList 
		addFilenamesFromStandardLibrariesDirectory: "Mac" 
		withExt:"mac" stripPath: YES stripExt: YES 
		ifAbsent: YES sorted: NO at: 0];
	
	// find first example if any
	
	strings=(char**)[tempStringList strings];
	filenames=(char**)[fileNameList strings];
	count=[tempStringList count];
	found=0;
	
	for (x=0;x<count;x++)
		{
		printf ("%s\t%s\n",filenames[x],strings[x]);
		}
	
	for (x=0;x<count;x++)
		{
		if (!strcmp(filenames[x],file)) {found=1; break;}	// got it.
		}
	
	printf ("%d %d\n",found,x);
	
	[return_val setBooleanVal:YES];
	
	if (found)		// I found one
		{
		id result=[controller playFile:strings[x]];
		if (result==NULL)
			{
			[return_val setString:"Mac error:  can't play requested macro"];
			[return_val setError:YES];
			}
		}
	else			// we must assume it's a full path name
		{
		id result=[controller playFile:file];
		if (result==NULL)
			{
			[return_val setString:"Mac error:  can't play requested macro"];
			[return_val setError:YES];
			}
		}
	[tempStringList free];
	[fileNameList free];
	[interpreter pauseInterpreting];
	paused=YES;
	return return_val;
	}
	
- journalerDidEnd:journaler
	{
	if (paused)
		{
		id this_node=[[COWSStringNode alloc] init];
		[this_node setBooleanVal:YES];
		[interpreter resumeInterpretingWithValue:this_node];
		[this_node free];
		paused=NO;
		}
	return self;
	}
	

	
@end