#import <appkit/appkit.h>

/******************************************************************************
PAStringList

	The PAStringList (a subclass of Storage) is a convenient way to deal with lists of character strings. It contains methods for adding strings, inserting strings, sorting strings and searching for strings.
	
	In addition the PAStringList object has methods for generating lists of filenames from a given directory. There is also a specific method for searching the standard libraries (/NextLibrary, /LocalLibrary, ~/Libary). Files can be limited to particular extensions and can be returned with or without their full path and extension.
	
	The PAStringList can also add strings from a tab/whitespace delimited string (such as the ones passed to an app by the workspace).
	
	Finally, the PAStringList implements a browser delegate method so that it can easily display itself if set to be a browser delegate.

	Copyright 1992, Jeff Martin (jmartin@next.com) (415) 780-3833.
******************************************************************************/

// Used for preloading with files from given libs or dirs with exts
typedef struct PreloadInfo {
	char	*plLibs;
	char	*plDirs;
	char	*plExts;
	BOOL	plFromAppDir, plFromBundleDir;
	BOOL	plStripPath, plStripExt, plIfAbsent, plSorted;
} PreloadInfo;

@interface PAStringList : Storage
{
	BOOL	isSorted;
	
	PreloadInfo *preloadInfo;	
}

// The main full function adding method (all other adds call this)
- addString:(const char *)string ifAbsent:(BOOL)ifAbsent noCopy:(BOOL)noCopy sorted:(BOOL)sorted at:(int)at;

// Convenience adding methods (defaulting to ifAbsent=NO, noCopy=NO, 
//		sorted=NO and at=count)
- addString:(const char *)string;
- addStringIfAbsent:(const char *)string;
- addStringNoCopy:(const char *)string;
- addStringIfAbsentNoCopy:(const char *)string;

- addString:(const char *)string at:(int)at;
- addStringIfAbsent:(const char *)string at:(int)at;
- addStringNoCopy:(const char *)string at:(int)at;
- addStringIfAbsentNoCopy:(const char *)string at:(int)at;

- addStringSorted:(const char *)string;
- addStringIfAbsentSorted:(const char *)string;
- addStringNoCopySorted:(const char *)string;
- addStringIfAbsentNoCopySorted:(const char *)string;

// Adding Multiple strings
- addStrings:(const char *const*)strings ifAbsent:(BOOL)ifAbsent noCopy:(BOOL)noCopy sorted:(BOOL)sorted at:(int)at;

// Adding another PAStringList
- addPAStringList:stringListObject ifAbsent:(BOOL)ifAbsent noCopy:(BOOL)noCopy sorted:(BOOL)sorted at:(int)at;

// Adding filenames from directories
- addFilename:(char *)filename stripPath:(BOOL)stripPath stripExt:(BOOL)stripExt ifAbsent:(BOOL)ifAbsent noCopy:(BOOL)noCopy sorted:(BOOL)sorted at:(int)at;
- addFilenames:(char **)filenames stripPath:(BOOL)stripPath stripExt:(BOOL)stripExt ifAbsent:(BOOL)ifAbsent noCopy:(BOOL)noCopy sorted:(BOOL)sorted at:(int)at;
- addFilenamesFromDirectory:(const char *)dir withExt:(const char *)ext stripPath:(BOOL)stripPath stripExt:(BOOL)stripExt ifAbsent:(BOOL)ifAbsent sorted:(BOOL)sorted at:(int)at;
- addFilenamesFromStandardLibrariesDirectory:(const char *)dir withExt:(const char *)ext stripPath:(BOOL)stripPath stripExt:(BOOL)stripExt ifAbsent:(BOOL)ifAbsent sorted:(BOOL)sorted at:(int)at;

// Adding individual strings from delimited (tab or otherwise) string
- addDelimitedStrings:(char *)string delimiters:(char *)dels;
- addDelimitedStrings:(char *)string delimiters:(char *)dels stripPath:(BOOL)stripPath stripExt:(BOOL)stripExt ifAbsent:(BOOL)ifAbsent noCopy:noCopy sorted:(BOOL)sorted at:(int)at;

// Finding strings in list
- (const char *const*)strings;
- (const char *)stringAt:(int)at;

// Finding the index of a given string and/or whether it is in list
- (BOOL)stringExists:(const char *)string;
- (unsigned)indexOfString:(const char *)string;
- (unsigned)indexOfString:(const char *)string exists:(BOOL *)exists;

// Removing strings from list
- removeString:(const char *)string;
- removeStrings:(const char *const*)strings;
- (char *)removeStringAt:(int)at;

// Sorting list
- (BOOL)isSorted;
- sortStrings:sender;

// input/output
- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;

// Cleanup
- freeStrings;
- free;

// Bonus NXBrowser support
- (int)browser:sender fillMatrix:matrix inColumn:(int)column;

@end


// Used for preloading files from directories or standard libs when unarchived
@interface PAStringList(Preloading)

- (PreloadInfo *)preloadInfo;

- (const char *)preLoadLibraries;
- setPreLoadLibraries:(const char *)libraries;

- (const char *)preLoadDirectories;
- setPreLoadDirectories:(const char *)directories;

- (const char *)preLoadExtensions;
- setPreLoadExtensions:(const char *)extensions;

- (BOOL)preLoadFromAppDir;
- setPreLoadFromAppDir:(BOOL)flag;

- (BOOL)preLoadFromBundleDir;
- setPreLoadFromBundleDir:(BOOL)flag;

- (BOOL)preLoadStripPath;
- setPreLoadStripPath:(BOOL)flag;

- (BOOL)preLoadStripExt;
- setPreLoadStripExt:(BOOL)flag;

- (BOOL)preLoadIfAbsent;
- setPreLoadIfAbsent:(BOOL)flag;

- (BOOL)preLoadSorted;
- setPreLoadSorted:(BOOL)flag;

- addPreLoadLibraryAndDirectoryFilenames;

@end

char *PAExpandFilename(char *fn);
