/*
	Copyright (C) 1994 Sean Luke

	COWSControllerInspector.m
	Version 1.4
	Sean Luke
	
	Only used in the COWS Palette to provide inspection for the COWSController
	and COWSUserController.
	
*/

#import "COWSControllerInspector.h"
#import "COWSController.h"
#import "COWSPaletteCategories.h"

@implementation COWSControllerInspector

- init
{
	char buf[MAXPATHLEN + 1];
	id bundle;
	
	[super init];
	
	bundle = [NXBundle bundleForClass:[COWSController class]];
	[bundle getPath:buf forResource:"COWSController" ofType:"nib"];
	[NXApp loadNibFile:buf owner:self withNames:NO fromZone:[self zone]];
	return self;
}

- ok:sender
{
	[object setLocked:[[buttonmatrix cellAt:0:0] intValue]];
	[object setForeground:[[buttonmatrix cellAt:1:0] intValue]];
	[object setTimedEntrySpeed:[[fieldmatrix cellAt:0:0] floatValue]];
	[object setPulsesPerTimedEntry:[[fieldmatrix cellAt:1:0] intValue]];
	[object setInitialFunction:[[fieldmatrix cellAt:2:0] stringValue]];
	[object setInitialArg1:[[fieldmatrix cellAt:3:0] stringValue]];
	[object setInitialArg2:[[fieldmatrix cellAt:4:0] stringValue]];
	[object setInitialArg3:[[fieldmatrix cellAt:5:0] stringValue]];
	[object setInitialArg4:[[fieldmatrix cellAt:6:0] stringValue]];
	if ([[automatrix cellAt:0:0] intValue]) 
		[object setAutostart:COWSCONTROLLER_NOAUTOLOAD];
	else if ([[automatrix cellAt:1:0] intValue])
		[object setAutostart:COWSCONTROLLER_AUTOLOAD];
	else [object setAutostart:COWSCONTROLLER_AUTOLOADANDRUN];
	return [super ok:sender];
}

- revert:sender
{
	[[buttonmatrix cellAt:0:0] setIntValue:[object locked]];
	[[buttonmatrix cellAt:1:0] setIntValue:[object foreground]];
	[[fieldmatrix cellAt:0:0] setFloatValue:[object timedEntrySpeed]];
	[[fieldmatrix cellAt:1:0] setIntValue:[object pulsesPerTimedEntry]];
	[[fieldmatrix cellAt:2:0] setStringValue:[object initialFunction]];
	[[fieldmatrix cellAt:3:0] setStringValue:[object initialArg1]];
	[[fieldmatrix cellAt:4:0] setStringValue:[object initialArg2]];
	[[fieldmatrix cellAt:5:0] setStringValue:[object initialArg3]];
	[[fieldmatrix cellAt:6:0] setStringValue:[object initialArg4]];
	if ([object autostart]==COWSCONTROLLER_NOAUTOLOAD)
		[automatrix selectCellAt:0:0];
	else if ([object autostart]==COWSCONTROLLER_AUTOLOAD)
		[automatrix selectCellAt:1:0];
	else [automatrix selectCellAt:2:0];
	return [super revert:sender];
}

- (BOOL) wantsButtons
{
	return NO;
}

- okSuper:sender
{
	return [super ok:sender];
}

- revertSuper:sender
{
	return [super revert:sender];
}

@end