/*
	Copyright (C) 1994 Sean Luke

	COWSPaletteCategories.h
	Version 1.4
	Sean Luke
	
	Categories to set up COWS objects into IB
	
*/

#import "COWSInterpreter.h"
#import "COWSController.h"
#import "COWSUserController.h"
#import "COWSLibrary.h"

@interface COWSInterpreter (COWSInterpreterIB)
- (NXImage*) getIBImage;
@end

@interface COWSController (COWSControllerIB)
- (const char*) getInspectorClassName;
- (NXImage*) getIBImage;	
- setInitialFunction:(const char*) this_value;
- setInitialArg1:(const char*) this_value;
- setInitialArg2:(const char*) this_value;
- setInitialArg3:(const char*) this_value;
- setInitialArg4:(const char*) this_value;
- setAutostart:(int) value;
- setForeground:(BOOL) yes_or_no;
- setLocked:(BOOL) yes_or_no;
- setTimedEntrySpeed:(float) this_value;
- setPulsesPerTimedEntry:(int) this_value;
- (const char*) initialFunction;
- (const char*) initialArg1;
- (const char*) initialArg2;
- (const char*) initialArg3;
- (const char*) initialArg4;
- (int) autostart;
- (BOOL) foreground;
- (BOOL) locked;
- (float) timedEntrySpeed;
- (int) pulsesPerTimedEntry;
@end

@interface COWSUserController (COWSUserControllerIB)
- (const char*) getInspectorClassName;
- (NXImage*) getIBImage;	
@end

@interface COWSLibrary (COWSLibraryIB)
- (NXImage*) getIBImage;	
@end
