/*
	Copyright (C) 1994 Sean Luke

	COWSPaletteCategories.m
	Version 1.4
	Sean Luke
	
	Categories to set up COWS objects into IB
	
*/

#import "COWSPaletteCategories.h"

@implementation COWSInterpreter (COWSInterpreterIB)
- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWS"];
	}
@end

@implementation COWSController (COWSControllerIB)
- (const char*)getInspectorClassName
	{
	return "COWSControllerInspector";
	}

- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWSController"];
	}	

- setInitialFunction:(const char*) this_value
	{
	strcpy(initial_function, this_value);
	return self;
	}
	
- setInitialArg1:(const char*) this_value
	{
	strcpy(initial_arg1, this_value);
	return self;
	}
	
- setInitialArg2:(const char*) this_value
	{
	strcpy(initial_arg2, this_value);
	return self;
	}
	
- setInitialArg3:(const char*) this_value
	{
	strcpy(initial_arg3, this_value);
	return self;
	}

- setInitialArg4:(const char*) this_value
	{
	strcpy(initial_arg4, this_value);
	return self;
	}

- setAutostart:(int) value
	{
	autostart=value;
	return self;
	}

- setForeground:(BOOL) yes_or_no
	{
	foreground=yes_or_no;
	return self;
	}

- setLocked:(BOOL) yes_or_no
	{
	locked=yes_or_no;
	return self;
	}

- setTimedEntrySpeed:(float) this_value
	{
	timed_entry_speed=this_value;
	return self;
	}

- setPulsesPerTimedEntry:(int) this_value
	{
	pulses_per_timed_entry=this_value;
	return self;
	}


- (const char*) initialFunction
	{
	return initial_function;
	}

- (const char*) initialArg1
	{
	return initial_arg1;
	}

- (const char*) initialArg2
	{
	return initial_arg2;
	}

- (const char*) initialArg3
	{
	return initial_arg3;
	}

- (const char*) initialArg4
	{
	return initial_arg4;
	}

- (int) autostart
	{
	return autostart;
	}

- (BOOL) foreground
	{
	return foreground;
	}

- (BOOL) locked
	{
	return locked;
	}

- (float) timedEntrySpeed
	{
	return timed_entry_speed;
	}

- (int) pulsesPerTimedEntry
	{
	return pulses_per_timed_entry;
	}

@end

@implementation COWSUserController (COWSUserControllerIB)
- (const char*)getInspectorClassName
	{
	return "COWSUserControllerInspector";
	}

- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWSUserController"];
	}	

@end

@implementation COWSLibrary (COWSLibraryIB)
- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWSLibrary"];
	}	
@end

