/*
	Copyright (C) 1994 Sean Luke

	COWSUserControllerInspector.m
	Version 1.4
	Sean Luke
	
	Only used in the COWS Palette to provide inspection for the COWSController
	and COWSUserController.
	
*/

#import "COWSUserControllerInspector.h"
#import "COWSUserController.h"
#import "COWSPaletteCategories.h"

@implementation COWSUserControllerInspector

- init
{
	char buf[MAXPATHLEN + 1];
	id bundle;
	
	[super init];
	
	bundle = [NXBundle bundleForClass:[COWSController class]];
	[bundle getPath:buf forResource:"COWSUserController" ofType:"nib"];
	[NXApp loadNibFile:buf owner:self withNames:NO fromZone:[self zone]];
	return self;
}

- ok:sender
{
	[object setLocked:[[buttonmatrix cellAt:0:0] intValue]];
	[object setForeground:[[buttonmatrix cellAt:1:0] intValue]];
	[object setTimedEntrySpeed:[[fieldmatrix cellAt:0:0] floatValue]];
	[object setPulsesPerTimedEntry:[[fieldmatrix cellAt:1:0] intValue]];
	return [super okSuper:sender];
}

- revert:sender
{
	[[buttonmatrix cellAt:0:0] setIntValue:[object locked]];
	[[buttonmatrix cellAt:1:0] setIntValue:[object foreground]];
	[[fieldmatrix cellAt:0:0] setFloatValue:[object timedEntrySpeed]];
	[[fieldmatrix cellAt:1:0] setIntValue:[object pulsesPerTimedEntry]];
	return [super revertSuper:sender];
}

- (BOOL) wantsButtons
{
	return NO;
}

@end