/*
	Copyright (C) 1994 Sean Luke

	COWSIBConnectorsCategories.m
	Version 1.0
	Sean Luke
	
*/

#import "COWSIBConnectorsCategories.h"


@implementation COWSIBControlInterface (COWSIBControlInterfaceIB)

- setOutputValue:(const char*)this
	{
	[self _prepareNodes];
	[output setString:this];
	return self;
	}

- setDefaultInputValue:(const char*)this
	{
	[self _prepareNodes];
	[default_input setString:this];
	return self;
	}

- setInput1Value:(const char*)this
	{
	[self _prepareNodes];
	[input_1 setString:this];
	return self;
	}

- setInput2Value:(const char*)this
	{
	[self _prepareNodes];
	[input_2 setString:this];
	return self;
	}

- setInput3Value:(const char*)this
	{
	[self _prepareNodes];
	[input_3 setString:this];
	return self;
	}

- setInput4Value:(const char*)this
	{
	[self _prepareNodes];
	[input_4 setString:this];
	return self;
	}

- setInput5Value:(const char*)this
	{
	[self _prepareNodes];
	[input_5 setString:this];
	return self;
	}

- setInput6Value:(const char*)this
	{
	[self _prepareNodes];
	[input_6 setString:this];
	return self;
	}

- setInput7Value:(const char*)this
	{
	[self _prepareNodes];
	[input_7 setString:this];
	return self;
	}

- setInput8Value:(const char*)this
	{
	[self _prepareNodes];
	[input_8 setString:this];
	return self;
	}


- (const char*) outputValue
	{
	[self _prepareNodes];
	return [output string];
	}

- (const char*) defaultInputValue
	{
	[self _prepareNodes];
	return [default_input string];
	}

- (const char*) input1Value
	{
	[self _prepareNodes];
	return [input_1 string];
	}

- (const char*) input2Value
	{
	[self _prepareNodes];
	return [input_2 string];
	}

- (const char*) input3Value
	{
	[self _prepareNodes];
	return [input_3 string];
	}

- (const char*) input4Value
	{
	[self _prepareNodes];
	return [input_4 string];
	}

- (const char*) input5Value
	{
	[self _prepareNodes];
	return [input_5 string];
	}

- (const char*) input6Value
	{
	[self _prepareNodes];
	return [input_6 string];
	}

- (const char*) input7Value
	{
	[self _prepareNodes];
	return [input_7 string];
	}

- (const char*) input8Value
	{
	[self _prepareNodes];
	return [input_8 string];
	}

- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWSIBControlInterface"];
	}

- (const char*)getInspectorClassName
	{
	return "COWSIBControlInterfaceInspector";
	}

- (BOOL) usingRadio
	{
	return use_radio;
	}

- useRadio:(BOOL) yes_or_no
	{
	use_radio=yes_or_no;
	return self;
	}

@end

@implementation COWSIBRadio (COWSIBRadioIB)
- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWSIBRadio"];
	}
@end

@implementation COWSIBSplitter (COWSIBSplitterIB)

- (BOOL) usingRadio
	{
	return use_radio;
	}

- useRadio:(BOOL) yes_or_no
	{
	use_radio=yes_or_no;
	return self;
	}

- (const char*)getInspectorClassName
	{
	return "COWSIBSplitterInspector";
	}

- (NXImage*) getIBImage
	{
	return [NXImage findImageNamed:"COWSIBSplitter"];
	}
@end
