/*
	Copyright (C) 1994 Sean Luke

	COWSIBControlInterfaceInspector.m
	Version 1.4
	Sean Luke
	
	Only used in the COWS IB Connectors palette to inspect 
	COWSIBControlInterfaces	
*/

#import "COWSIBControlInterfaceInspector.h"
#import "COWSIBControlInterface.h"
#import "COWSIBConnectorsCategories.h"

@implementation COWSIBControlInterfaceInspector

- init
{
	char buf[MAXPATHLEN + 1];
	id bundle;
	
	[super init];
	
	bundle = [NXBundle bundleForClass:[COWSIBControlInterface class]];
	[bundle getPath:buf forResource:"COWSIBControlInterfaceInspector" ofType:"nib"];
	[NXApp loadNibFile:buf owner:self withNames:NO fromZone:[self zone]];
	return self;
}

- ok:sender
{
	[object setOutputValue:[outputfield stringValue]];
	[object setDefaultInputValue:[defaultinputfield stringValue]];
	[object setInput1Value:[[fieldmatrix cellAt:0:0] stringValue]];
	[object setInput2Value:[[fieldmatrix cellAt:1:0] stringValue]];
	[object setInput3Value:[[fieldmatrix cellAt:2:0] stringValue]];
	[object setInput4Value:[[fieldmatrix cellAt:3:0] stringValue]];
	[object setInput5Value:[[fieldmatrix cellAt:4:0] stringValue]];
	[object setInput6Value:[[fieldmatrix cellAt:5:0] stringValue]];
	[object setInput7Value:[[fieldmatrix cellAt:6:0] stringValue]];
	[object setInput8Value:[[fieldmatrix cellAt:7:0] stringValue]];
	[object useRadio:(BOOL) [use_radio intValue]];
	return [super ok:sender];
}

- revert:sender
{
	[outputfield setStringValue:[object outputValue]];
	[defaultinputfield setStringValue:[object defaultInputValue]];
	[[fieldmatrix cellAt:0:0] setStringValue:[object input1Value]];
	[[fieldmatrix cellAt:1:0] setStringValue:[object input2Value]];
	[[fieldmatrix cellAt:2:0] setStringValue:[object input3Value]];
	[[fieldmatrix cellAt:3:0] setStringValue:[object input4Value]];
	[[fieldmatrix cellAt:4:0] setStringValue:[object input5Value]];
	[[fieldmatrix cellAt:5:0] setStringValue:[object input6Value]];
	[[fieldmatrix cellAt:6:0] setStringValue:[object input7Value]];
	[[fieldmatrix cellAt:7:0] setStringValue:[object input8Value]];
	[use_radio setIntValue:(int) [object usingRadio]];
	return [super revert:sender];
}

- (BOOL) wantsButtons
{
	return NO;
}

@end