/*
	Copyright (C) 1994 Sean Luke

	COWSIBSplitterInspector.m
	Version 1.4
	Sean Luke
	
	Only used in the COWS IB Connectors palette to inspect 
	COWSIBSplitterInspector	
*/

#import "COWSIBSplitterInspector.h"
#import "COWSIBSplitter.h"
#import "COWSIBConnectorsCategories.h"

@implementation COWSIBSplitterInspector

- init
{
	char buf[MAXPATHLEN + 1];
	id bundle;
	
	[super init];
	
	bundle = [NXBundle bundleForClass:[COWSIBControlInterface class]];
	[bundle getPath:buf forResource:"COWSIBSplitterInspector" ofType:"nib"];
	[NXApp loadNibFile:buf owner:self withNames:NO fromZone:[self zone]];
	return self;
}

- ok:sender
{
	[object useRadio:(BOOL) [use_radio intValue]];
	return [super ok:sender];
}

- revert:sender
{
	[use_radio setIntValue:(int) [object usingRadio]];
	return [super revert:sender];
}

- (BOOL) wantsButtons
{
	return NO;
}

@end