/*
	Copyright (C) 1994 Sean Luke

	COWSArrayLibrary.h
	Version 1.0
	Sean Luke
	
*/

// Note that the hash table that stores arrays is not cleared out until
// the array is reloaded or freed.  This means that programs can be run
// and rerun, even reloaded, and the same pointers are in the hash table
// unless they've been removed with free-array.


#import "COWSLibrary.h"

@interface COWSArrayLibrary:COWSLibrary <InterpreterToLibrary>
{
	id hashtable;
	int counter;
	BOOL inited;
}

- init;
- awake;
- free;
							
- array_makearray:arg_list;	// makes an array and returns a key to the array
- array_freearray:arg_list;	// frees an array by key
- array_setarray:arg_list;	// sets a value in an array by key
- array_getarray:arg_list;	// gets a value in an array by key
- array_isarray:arg_list;	// returns t if value is a valid array, f if not

@end