/*
	Copyright (C) 1994 Sean Luke

	COWSArrayNode.m
	Version 1.0
	Sean Luke
	
*/




#import "COWSArrayNode.h"

@implementation COWSArrayNode

- initTable:(const int*) these_limits:(int) this_num_limits;
	{
	int x;
	
	// determine if limit number is valid
	
	size=0;
	num_limits=this_num_limits;
	if (num_limits<=0||num_limits>256) 
		{
		[self free];
		return NULL;		// bad limits!
		}
	
	// load limits and compute total size
	
	size=1;
	for (x=0;x<num_limits;x++)
		{
		limits[x]=these_limits[x];
		if (limits[x]<=0)				// any limit is 0 or lower
			{
			size=0;
			[self free];
			return NULL;
			}
		size*=limits[x];
		}
		
	// allocate table
	
	table=calloc(size,sizeof(COWSStringNode*));
	for (x=0;x<size;x++)
		{
		table[x]=[[COWSStringNode alloc] init];
		}
		
	return self;
	}
	
- setValue:(const int*) coords:(COWSStringNode*) value
	{
	int offset=1;
	int val=0;
	int x;
	
	for (x=0;x<num_limits;x++)
		{
		if (coords[x]<=0||coords[x]>limits[x]) return NULL;
		val+=((coords[x]-1)*offset);
		offset*=limits[x];
		}
	[table[val] copyValue:value];
	return self;
	}
	
- (COWSStringNode*) value:(const int*) coords
	{
	int offset=1;
	int val=0;
	int x;
	
	for (x=0;x<num_limits;x++)
		{
		if (coords[x]<=0||coords[x]>limits[x]) return NULL;
		val+=((coords[x]-1)*offset);
		offset*=limits[x];
		}
	return table[val];
	}
	
- free
	{
	int x;
	for (x=0;x<size;x++) [table[x] free];
	return [super free];
	}

	
@end