/*
	Copyright (C) 1994 Sean Luke

	COWSController.h
	Version 1.4
	Sean Luke
	
	Allows easy hookup to libraries and control nib and interpreter,
	for automatic COWS running
	
*/



#import <appkit/appkit.h>
#import "COWSProtocols.h"
#define COWSCONTROLLER_TYPICALSTRING		256
#define COWSCONTROLLER_NOAUTOLOAD			0
#define COWSCONTROLLER_AUTOLOAD				1
#define COWSCONTROLLER_AUTOLOADANDRUN		2

@interface COWSController:Object <InterpreterToDelegate>
{
	BOOL	inited;
	
	char	initial_function[COWSCONTROLLER_TYPICALSTRING];
	char	initial_arg1	[COWSCONTROLLER_TYPICALSTRING];
	char	initial_arg2	[COWSCONTROLLER_TYPICALSTRING];
	char	initial_arg3	[COWSCONTROLLER_TYPICALSTRING];
	char	initial_arg4	[COWSCONTROLLER_TYPICALSTRING];
	char	autostart;	
	BOOL	foreground;
	BOOL	locked;
	float	timed_entry_speed;
	int		pulses_per_timed_entry;

	id		program;			// should be a text field
	id		interpreter;
	id		library1;
	id		library2;
	id		library3;
	id		library4;
	id		library5;
	id		library6;
	id		library7;
	id		library8;
	id		delegate;
}

- init;
- awake;
//- appDidInit:sender;
- start:sender;			// called by interface builder buttons since IB
						// doesn't send awakeFromNib to controller

- read:(NXTypedStream*) stream;
- write:(NXTypedStream*) stream;


@end
