/*
	Copyright (C) 1994 Sean Luke

	COWSIPCLibrary.h
	Version 1.0
	Sean Luke
	
*/




#import "COWSLibrary.h"
#import <string.h>
#import <stdlib.h>
#import <stdio.h>
#import <remote/NXConnection.h>
#import "COWSProtocols.h"


#define	COWSIPCLIBRARY_ARGSTATE_READY	-1
#define COWSIPCLIBRARY_ARGSTATE_WORKING	1
#define COWSIPCLIBRARY_ARGSTATE_ADDING	2
#define COWSLARGESTPATHLENGTH			MAXHOSTNAMELEN+100
#define COWSIPCLIBRARY_MAXERRSTRINGLENGTH	256

@interface COWSIPCLibrary:COWSLibrary <InterpreterToLibrary,InterpreterIPC,InterpreterToDelegate,InterpreterToLibraryDelegate>
{
	id 			interpreter;
	id			server;
	BOOL		error;
	id			connection;
	id			caller;
	COWSArgumentList*	arguments;
	int			arguments_state;
	COWSStringNode* result;			// given by delegate message
	BOOL		inited;
	DPSTimedEntry
				teNum;
	BOOL		started;
}

- init;
- awake;

// COWS functions

- ipc_send:arg_list;			// synchronous to same machine
- ipc_sendout:arg_list;			// asynchronous to same machine
- ipc_send_machine:arg_list;	// synchronous to different machine
- ipc_sendout_machine:arg_list;	// asynchronous to different machine
- ipc_launch:arg_list;			// launches to same machine or different
- ipc_launched:arg_list;			// checks on same machine or different

// COWS libraries are registered as APPNAME(COWS) where APPNAME is the app's
// name.  For example, Edit would be Edit(COWS).

// private timer function.  Don't call, please.
- _checkup;


@end