/*
	Copyright (C) 1994 Sean Luke

	COWSInterpreter.h
	Version 1.4
	Sean Luke
	
*/






#import <objc/Object.h>
#import <appkit/appkit.h>		// for timed entry
#import <objc/HashTable.h>
#import <string.h>
#import <stdio.h>
#import <stdlib.h>
#import "COWSStack.h"
#import "COWSStringNode.h"
#import "COWSProtocols.h"
#import <appkit/NXImage.h>		// for Interface Builder


// Types of interpretation
#define COWSINTERPRETATIONUNDEFINED	0
#define COWSINTERPRETATIONLIBRARY	1	// a library function was requested
#define COWSINTERPRETATIONFUNCTION	2	// a user's program was requested

// Limits
#define COWSLARGENUMBER 256		// the longest valid string length for a number
								// I define this because sprintf requires an
								// array, and not just a character pointer.
								// I wish there was another way around this,
								// but I don't think so...

// Success Marker
#define COWSSUCCESS					 0		// >=0 also means parse succeeded

// Interpreter Bugs
#define COWSINTERNALERROR			-1		// bug in COWS

// Initial Parse Errors
#define COWSERRORNOMORETOKENS		-2		// not enough tokens to parse
#define COWSERRORSYNTAX				-3		// syntax error
#define COWSERRORNOCLOSINGQUOTE		-4		// no closing quote to a string
#define COWSERRORDUPLICATEGLOBAL	-5		// duplicate global variable
#define COWSERRORDUPLICATEVARIABLE	-6		// duplicate variable or argument
#define COWSERRORDUPLICATEARGUMENT	-7		// duplicate argument
#define COWSERRORDUPLICATEFUNCTION	-18		// duplicate function

// Interpreter Syntax Errors
#define COWSERRORNOSUCHFUNCTION		-8		// can't find function by that name
#define COWSERRORNOTENOUGHARGUMENTS	-9		// too few arguments to function
#define COWSERRORTOOMANYARGUMENTS	-10		// too many aguments to function
#define COWSLIBRARYFUNCTIONERROR	-11		// library function error
#define COWSERRORNOSUCHVARIABLE		-12		// can't find variable by that name
//      COWSERRORNOMORETOKENS				// not enough tokens to parse
#define COWSERRORNOFUNCTIONNAME		-13		// no function/keyword name after (

// Keyword Syntax Errors
#define COWSERRORSETNOTVARIABLE		-14		// can't set; not a variable
#define COWSERRORSETTOOMANYVALUES	-15		// can't set; too many values
#define COWSERRORSETNOVALUE			-16		// can't set; no value
#define COWSERRORSETNOSUCHVARIABLE	-17		// can't set; no such variable
#define COWSERRORIFNOTHENCLAUSE		-19		// can't if; no then clause
#define COWSERRORIFTOOMANYVALUES	-20		// can't if; too many values
#define COWSERRORIFNOTENOUGHVALUES	-21		// can't if; not enough values
#define COWSERRORWHILETOOMANYVALUES -22		// can't while; too many values
#define COWSERRORWHILENOTENOUGHVALUES -23	// can't while; not enough values
#define COWSERRORFORNOTAVARIABLE	-24		// can't for; not a variable
#define COWSERRORFORSTARTNOTNUMBER	-25		// can't for; start value not a #
#define COWSERRORFORSTOPNOTNUMBER	-26		// can't for; stop value not a #
#define COWSERRORFORSTEPNOTNUMBER	-27		// can't for; step value not a #
#define COWSERRORFORNOSUCHVARIABLE	-28		// can't for; no such variable
#define COWSERRORFORTOOMANYVALUES	-29		// can't for; too many values
#define COWSERRORFORNOTENOUGHVALUES	-30		// can't for; not enough values

// convenience functions

char* newstr(const char* ct);
	// strcpys ct into a new string, returning the new string's pointer.

char* newstrn(const char*ct, int size);
	// strncpys ct into a new string, returning the new string's pointer.
	
	
@interface COWSInterpreter:Object   <InterpreterControl, LibraryControl>
{
	BOOL		inited;					// flag to make sure only inited once
	COWSStringNode*	
				program;
	BOOL		running;			
	BOOL		function_completed;
	BOOL		foreground;				// default is NO
	BOOL		locked;					// cannot be used by another process
	BOOL		working;				// working on a task, paused or no.
	BOOL		printing_errors;		// default is YES
	int			repeats;
	id			tempDelegate;			// a miscellaneous delegate to be
										// used only by a current library
										// or whatnot
	id			delegate;				// the application's official delegate
	DPSTimedEntry
				teNum;
	float		te_speed;				// default 0.1
	COWSStack*	stack;
	COWSArgumentList* library_delegates;
	HashTable* 	function_dictionary;
	HashTable*	library_dictionary;
	HashTable*	global_dictionary;
	HashTable*	current_dictionary;
	COWSStringNode*
				current_function;
	int			current_position;
	int			interpretation;			// when a user starts a request,
										// this is set to whether it's a macro
										// request or just a program function
										// request...
}

- init;
- awake;								// calls init if not called already
- free;
- addLibrary:this_library;						 // returns NULL if unable
- addLibraryFunction:(const char*) this_name
	selector: (SEL) this_selector
	target: this_target;
- makeMeALibraryDelegate:sender;
- clearLibraryFunctions;
- setTimedEntrySpeed:(float)this_speed;				// in seconds
- (float) timedEntrySpeed;
- setForeground:(BOOL) yes_or_no;
- (BOOL) foreground;
- setLocked:(BOOL) yes_or_no;
- (BOOL) locked;
- (BOOL) working;							// you can't change this
- (BOOL) running;							// you can't change this
- (int) setProgram:(const char*) this_string;	
	// parses through this_string and places pieces in various
	// dictionaries.  Returns an error code.
- printDictionaries:sender;
- printProgram:sender;
- setTempDelegate:this_delegate;
- tempDelegate;
- setDelegate:this_delegate;
- delegate;
- setRepeats:(int) this_number;
- (int) repeats;
- interpretFunction:(const char*) this_name 
	arguments:(COWSArgumentList*)these_arguments;
		// interprets function this_name with arguments these_arguments
		// it is your responbility to free these_arguments after calling
		// this function.
		// Returns the interpreter.  Don't free the return value!!!  :-)
- stopInterpreting;
- (BOOL) canPause;
- pauseInterpreting;
- resumeInterpreting;
- resumeInterpretingWithValue:(COWSStringNode*)this_value;
- printErrors:(BOOL) yes_or_no;
- (BOOL) printingErrors;




// Tokenizer.  Don't touch this.

- (int) _tokenize:(const char*) string:(int) pos:(COWSStringNode*) token;



// Recursive descent parser functions.
// Don't touch these.

- (int) _item:(const char*)string:(int)pos;
- (int) _itemList:(const char*)string:(int)pos;
- (int) _variableList:(const char*) string:(int)pos;
- (int) _globalForm:(const char*)string:(int)pos;
- (int) _argumentList:(const char*) string:(int)pos:
		(COWSArgumentList*) arguments;
- (int) _localVariableList:(const char*) string:(int)pos: 
		(HashTable*) arguments;
- (int) _functionForm:(const char*)string:(int)pos;
- (int) _programList:(const char*)string:(int)pos;
- (int) _program:(const char*)string:(int)pos;


// Recursive descent parser terminal functions.
// Don't touch these.

- (int) _symbolName:(const char*)string:(COWSStringNode*)s:(int)pos;
- (int) _atom:(const char*)string:(int)pos;
- (int) _beginKeyword:(const char*)string:(int)pos;
- (int) _functionKeyword:(const char*)string:(int)pos;
- (int) _variableKeyword:(const char*)string:(int)pos;
- (int) _closeParen:(const char*)string:(int)pos;
- (int) _openParen:(const char*)string:(int)pos;



// Interpreter functions
// Don't touch these.

- _executeProgram:(COWSArgumentList*) arguments:(COWSStringNode*) symbol;
- _performFunction;
- _performInternalFunction:
		(COWSArgumentList*) arguments:(COWSStringNode*) symbol;
- _performLibraryFunction:
		(COWSArgumentList*) arguments:(COWSStringNode*) symbol;
- _completeFunction;
- _evaluateVariable:(COWSStringNode*) symbol;
- _doKeywords;
- _go;				// called by the timed entry 
- _readEval;		// called by _go <repeats> number of times


// Interpreter Keyword functions
// Don't touch these.

- _startSet;
- _doSet;
- _finishSet;
- _startIf;
- _doIf;
- _finishIf;
- _startWhile;
- _doWhile;
- _finishWhile;
- _startFor;
- _doFor;
- _finishFor;


// Interpreter assistance functions
// Don't touch these.

- (int) _skip;		// skips one value if there is one.  Returns error if not.
- _makeTruth:(COWSStringNode*) string;		// makes a truth a node string
- _makeNumber:(COWSStringNode*) string;		// makes a number a proper number.
											// bad numbers may wind up
											// different than expected or 0!
- _strip:(COWSStringNode*) string;			// strips strings of their "s
- (int) _error:(int) this_error:
	(const char*) this_function:
	(int) this_position: 
	(const char*) this_string;				// reports an error.

@end




