/*
	Copyright (C) 1994 Sean Luke

	COWSStateNode.m
	Version 1.0
	Sean Luke
	
*/




#import "COWSStateNode.h"
#import "COWSInterpreter.h"

@implementation COWSStateNode

- init
	{
	id returnval=[super init];
	dictionary=[[HashTable alloc] initKeyDesc:"*"valueDesc:"*"];
	arguments=[[COWSArgumentList alloc] init];
	pos=0;
	return returnval;
	}

- free
	{
	[dictionary freeObjects];
	[dictionary free];
	[arguments free];
	return [super free];
	}
	
- (int) pos
	{
	return pos;
	}
	
- setPos:(int) this
	{
	pos=this;
	return self;
	}

- (COWSArgumentList*) arguments
	{
	return arguments;
	}
	
	
- (HashTable*) dictionary
	{
	return dictionary;
	}

- printContents
	{
	id value_node;
	const char *value;
	const void *key;
	NXHashState state=[dictionary initState];
	printf ("\tARGS/VARS\n");
	while ([dictionary nextState: &state key: &key value: (void*) &value_node])
		{
		char* temp=(char*)key;
		value=[value_node string];
		printf ("\tKEY:   #%s#\n\tVALUE: #%s#  %d  %d\n",(char*) key, 
			(const char*) value,strlen(temp),
				(unsigned int)(temp[strlen(temp)-1]));
		}
	printf ("\tPOS:  %d\n",pos);
	printf ("\tARG LIST\n");
	[arguments printContents];
	return self; 
	}
	
- setArguments:this
	{
	[arguments free];
	arguments=this;
	return self;
	}	
	
- setStringNoCopy:(char*) this_string
	{
	if (string!=NULL) free(string);
	string=this_string;
	return self;
	}
	
- copy
	{
	const void*key;
	void*value;
	NXHashState state=[dictionary initState];
	id copy_node=[[COWSStateNode alloc] init];
	id new_dictionary;
	
	[copy_node setPos:[self pos]];
	[copy_node copyValue:self];						// the now-accepted
													// way to copy string nodes
	[copy_node setArguments:[arguments copy]];
	new_dictionary=[copy_node dictionary];
	while ([dictionary nextState:&state key: &key value: &value])
		{
		char* old_key=(char*) key;
		id old_val=(COWSStringNode*) value;
		id new_val=[[COWSStringNode alloc] init];
		[new_val copyValue:old_val];
		[new_dictionary insertKey:newstr(old_key) value:(void*)new_val];
		}
	return copy_node;
	}
	
@end