/*
	Copyright (C) 1994 Sean Luke

	COWSIBControlInterface.h
	and COWSControlIB--a category for Controls
	and COWSCellIB--a category for Cells
	Version 1.0
	Sean Luke
	
*/




#import "COWSLibrary.h"
#import "COWSIBRadio.h"

#define COWSIBCONTROLINTERFACE_ACTION	0
#define COWSIBCONTROLINTERFACE_STRING	1
#define COWSIBCONTROLINTERFACE_INT		2
#define COWSIBCONTROLINTERFACE_FLOAT	3
#define COWSIBCONTROLINTERFACE_DOUBLE	4

#define COWS_id	id					// hides from IB

extern COWSIBRadio* COWSRADIO;

@interface COWSIBControlInterface:COWSLibrary <InterpreterToLibrary>
{
	COWS_id			target;			// see above
	COWS_id 		interpreter;	// likewise
	
	COWSStringNode* value;
	COWSStringNode* output;
	COWSStringNode* default_input;
	COWSStringNode* input_1;
	COWSStringNode* input_2;	
	COWSStringNode* input_3;	
	COWSStringNode* input_4;
	COWSStringNode* input_5;
	COWSStringNode* input_6;
	COWSStringNode* input_7;
	COWSStringNode* input_8;					
	SEL	action;
	id	input1;
	id	input2;
	id	input3;
	id	input4;
	id	input5;
	id	input6;
	id	input7;
	id	input8;
	int	inited;
	BOOL	use_radio;
}

- awake;
- init;
- free;

- setTarget:anObject;
- setAction:(SEL)aSelector;
- (SEL)action;
- target;

- takeDoubleValueFrom:sender;
- takeFloatValueFrom:sender;
- takeIntValueFrom:sender;
- takeStringValueFrom:sender;
- do:sender;
- (const char*) stringValue;
- (int) intValue;
- (float) floatValue;
- (double) doubleValue;
- setStringValue:(const char*) this;
- setFloatValue:(float) this;
- setIntValue:(int) this;
- setDoubleValue:(double) this;

- read:(NXTypedStream*) stream;
- write:(NXTypedStream*) stream;

- performOutput:(COWSArgumentList*)arg_list;

- _prepareNodes;		// only to be used privately, thank you

@end

@interface Object (COWSObjectIB)		// these are dummy methods
										// overriden by cells and controls

- returnIntValue:sender;
- returnFloatValue:sender;
- returnStringValue:sender;
- returnDoubleValue:sender;

@end

@interface Cell (COWSCellIB)

- returnIntValue:sender;
- returnFloatValue:sender;
- returnStringValue:sender;
- returnDoubleValue:sender;

@end


@interface Control (COWSControlIB)

- returnIntValue:sender;
- returnFloatValue:sender;
- returnStringValue:sender;
- returnDoubleValue:sender;

@end