/*
	Copyright (C) 1994 Sean Luke

	COWSIBRadio.m
	Version 1.0
	Sean Luke
	
*/




#import "COWSIBRadio.h"
#import "COWSLibraryNode.h"
#import <stdlib.h>

@implementation COWSIBRadio

- awake
	{
	if (!inited) return [self init];
	return self;
	}

- init
	{
	id returnval;
	if (inited)	return self;
	returnval=[super init];
	if (!COWS_RADIO) COWS_RADIO=self;
	connectors=[[COWSArgumentList alloc] init];
	inited=1;
	return returnval;
	}

- free
	{
	[connectors free];
	return self;
	}


- loadLibrary:sender
	{
	id returnval=[super loadLibrary:sender];
	
	if (![sender conformsTo:@protocol(LibraryControl)])
		{
		printf ("IBLibrary error:  Interpreter cannot accept Library Control protocol!\n");
		return NULL;
		}
	
	// call connectors
	
	[connectors first];
	while ([connectors now])
		{
		[[[connectors now] target] loadLibrary:sender];
		[connectors next];
		}
		
	return returnval;
	}
	
- add:sender
	{
	id temp=[[COWSLibraryNode alloc] init];
	[temp setTarget:sender];
	[connectors push:temp];
	return self;
	}

@end