/*
	Copyright (C) 1994 Sean Luke

	COWSIBSplitter.m
	Version 1.0
	Sean Luke
	
*/




#import "COWSIBSplitter.h"

@implementation COWSIBSplitter

- awake
	{
	if (!inited) return [self init];
	return self;
	}

- init
	{
	id returnval=[super init];
	if (use_radio)
		if (COWS_RADIO) [COWS_RADIO add:self];	// connects to radio if no
												// interpreter and radio 
												// exists
	inited=1;
	return returnval;
	}


- loadLibrary:sender
	{
	id returnval=[super loadLibrary:sender];
	
	if (![sender conformsTo:@protocol(LibraryControl)])
		{
		printf ("IBLibrary error:  Interpreter cannot accept Library Control protocol!\n");
		return NULL;
		}
	
	// call sublibraries
	
	if (library1) [library1 loadLibrary:sender];
	if (library2) [library2 loadLibrary:sender];
	if (library3) [library3 loadLibrary:sender];
	if (library4) [library4 loadLibrary:sender];
	if (library5) [library5 loadLibrary:sender];
	if (library6) [library6 loadLibrary:sender];
	if (library7) [library7 loadLibrary:sender];
	if (library8) [library8 loadLibrary:sender];
			
	return returnval;
	}
	
- read:(NXTypedStream*) stream
	{
	[super read:stream];
	NXReadTypes(stream,"c",&use_radio);
	return self;
	}
	
- write:(NXTypedStream*) stream
	{
	[super read:stream];
	NXWriteTypes(stream,"c",&use_radio);
	return self;
	}

@end