/*
        Copyright (C) 1994 Sean Luke

        COWSStringNode.h
        Version 1.5a_mj
        Code mangled beyond recognition by Michal Jaegermann
		Slight modifications by Sean Luke

*/


#import "COWSNode.h"
#import <stdio.h>

#define COWSSTRINGNODE_STORED_STRING    1
#define COWSSTRINGNODE_STORED_NUMBER    2
#define COWSSTRINGNODE_STORED_ERROR     4   // error message flag
                                            // for use by library functions

/* flag manipulation macros  - set, clear and check flag X in flags f */
#define SN_SET(f,X)   (f) |= X
#define SN_CLEAR(f,X) (f) &= (~X)
#define SN_CHECK(f,X) ((f) & X)         // X is set iff this is non-zero
#define STORED_STRING(f) (0 != ((f) & COWSSTRINGNODE_STORED_STRING))
#define STORED_NUMBER(f) (0 != ((f) & COWSSTRINGNODE_STORED_NUMBER))
#define STORED_ERROR(f)  (0 != ((f) & COWSSTRINGNODE_STORED_ERROR))

@interface COWSStringNode:COWSNode
{
    char               *string;
    size_t              len;            // how much allocated in string
                                        // total - trailing zeros and stuff
    double              double_value;
    int                 value_flags;    // which interpretations are
                                        // valid for a stored value
}

- init;
- free;
- (const char *)string;
	// returns "" if string is either empty or NULL at the moment
	// returns the string value if there is one
	// returns the value converted into a string if it is of a different type.
- setString:(const char *)this;
- setString:(const char *)this size:(size_t)this_size;  // tacks on a \0

- setIntVal:(int)this;  // different from setIntValue to avoid warnings
- (int)intVal;          // etc.
- setFloatVal:(float)this;
- (float)floatVal;
- setDoubleVal:(double)this;
- (double)doubleVal;

- setBooleanVal:(BOOL)this;     // note that booleans are NOT equivalent to
 // ints--all ints evaluate to TRUE, including
 // 0.  Booleans are defined as non-empty
 // strings (canonically "t") for TRUE, and
 // empty strings for FALSE.
- (BOOL)booleanVal;
- (BOOL)isCanonicallyTrue;      // =="t"
- (BOOL)isCanonicallyFalse;     // =="" This is equivalent to !booleanVal
 // for this string node (COWS), but for other
 // languages (i.e., tcl), it could be needed
 // so is included for symmetry

- copyValue:(COWSStringNode *) from_this;   // copying from another string node
- (int)value_state;             // the value state (string, number, error)
                                // all three can be valid in the same time
#if 0
/* for a future use?? */
// append 'this' to a string stored in COWSStringNode
- (const char *)catString :(const char *)this;
// add 'this' to a number stored in COWSStringNode
- (double)addToVal :(double)this;
#endif


- setError:(BOOL)true_or_false;
- (BOOL)error;

- printContents;                // debugging

@end
