package awwwesome.visualworld;
import java.awt.*;


/** This is an attempt at a simple 3D Canvas.  It contains a central rendering area (a VwCanvas)
  surrounded on all sides by four scroll bars.  The top scroll bar zooms in and out.
  The left scroll bar rotates on the Z axis.  The right scroll bar rotates on the X
  axis.  The bottom scroll bar rotates on the Y axis.

  <p>The Java AWT is really terrible.  One object it doesn't contain is something that
  lets you drag and hold, while it continually sends messages to the respective controller
  object.  So I'm using a scroll bar right now, which doesn't do a good job.  You need
  to drag the scroller, but constantly move it a little to continue to send messages to
  the system.  Duh.  Sorry about that.  If someone can replace this with a more intelligent
  dragger assembly, I'd appreciate it. :-)

  <p>A Canvas3D implements the HitInterface interface, allowing it to respond to mouse clicks
  in the VwCanvas area. This can be used for selecting objects, for example.  You can set up
  a delegate object which also receives the HitInterface interface, which will get passed
  on from the Canvas3D when a mouse click occurs, by calling setHitTarget().

*/

public class Canvas3D extends Panel implements HitInterface
    {
    VwCanvas vwcanvas;
    Scrollbar scrollx;
    Scrollbar scrolly;
    Scrollbar scrollz;
    Scrollbar scrollm;
    public VisualWorld vw;
    
    Vector4 origin;
    Vector4 cameraLoc;   // Where the camera is
    Vector4 cameraDir;   // Perceived Z direction of camera
    Vector4 cameraUp;	 // Perceived Y direction of camera
    Vector4 cameraLeft;	 // Perceived X direction of camera
    
    HitInterface target;

    public Canvas3D()
	{
	setLayout(new BorderLayout());
	add("East",scrolly = new Scrollbar(Scrollbar.VERTICAL,0,3,-15,15));
	add("South",scrollx = new Scrollbar(Scrollbar.HORIZONTAL,0,3,-15,15));
	add("West",scrollz = new Scrollbar(Scrollbar.VERTICAL,0,3,-15,15));
	add("North",scrollm = new Scrollbar(Scrollbar.HORIZONTAL,0,9,-45,45));
	add("Center",vwcanvas = new VwCanvas(vw = new VisualWorld()));
	vw.setBgColor(Color.white);
	vwcanvas.target=this;

	cameraLoc  = new Vector4();
        cameraDir  = new Vector4();
        cameraUp   = new Vector4();
        cameraLeft = new Vector4();
        origin = new Vector4();
	initCamera();
	}

    public void doMouseEvent (int x, int y)
	{
	if (target!=null) target.doMouseEvent(x,y);
	}

    /** Set the person to pass mouse event information on to. */
    public void setHitTarget(HitInterface t)
	{
	target=t;
	}

    public void reshape(int x, int y, int w, int h) 
    {
        super.reshape(x, y, w, h);
        updateCamera();
    }

    /** Set camera to initial settings. */
    public void initCamera()
	{
	origin.v[0] = origin.v[1]=origin.v[2]=0; origin.v[3]=1;  /* It's a point */

        cameraLoc.v[0] = cameraLoc.v[1] = 0;
        cameraLoc.v[2] = 100; cameraLoc.v[3]=0;   /* it's a vector */

        cameraDir.v[0] = cameraDir.v[1] = 0;
        cameraDir.v[2] = -1;  cameraDir.v[3]=0;   /* it's a vector */

        cameraUp.v[0] = cameraUp.v[2] = 0;
        cameraUp.v[1] = 1;   cameraDir.v[3]=0;    /* it's a vector */

        cameraLeft.v[0] = -1;
        cameraLeft.v[1] = cameraLeft.v[2] = 0;
	cameraLeft.v[3] = 0;                     /* it's a vector */
	updateCamera();
	}


    public void updateCamera()
	{
        if (vw == null) return;

        vw.setCameraDirection(cameraDir);
        vw.setCameraUp(cameraUp);
        vw.setCameraLocation(cameraLoc);
	}

    void updateCamera(Vector4 origin, Vector4 loc, Vector4 dir, Vector4 up, Vector4 left)
	{
	this.origin=origin.copy(); cameraLoc=loc.copy(); cameraDir=dir.copy();
	cameraUp=up.copy(); cameraLeft=left.copy();
	updateCamera();
	}

    public boolean handleEvent(Event evt)
	{
	if (evt.target instanceof Scrollbar &&
	    (evt.id == Event.SCROLL_ABSOLUTE ||
	    evt.id == Event.SCROLL_LINE_DOWN ||
	    evt.id == Event.SCROLL_LINE_UP ||
	    evt.id == Event.SCROLL_PAGE_DOWN ||
	    evt.id == Event.SCROLL_PAGE_UP))
	    {
	    Scrollbar s=(Scrollbar)(evt.target);
	    if (s.getValue()==0) return false;
	    
	    Matrix4x4 rot;

	    int sc_amount=0;
	    if (evt.id == Event.SCROLL_ABSOLUTE)
		sc_amount=s.getValue();
	    else if (evt.id == Event.SCROLL_LINE_DOWN)
		sc_amount=1;
	    else if (evt.id == Event.SCROLL_LINE_UP)
		sc_amount=-1;
	    else if (evt.id == Event.SCROLL_PAGE_DOWN)
		sc_amount=15;
	    else if (evt.id == Event.SCROLL_PAGE_UP)
		sc_amount=-15;

	    if (evt.target == scrolly)
		{
		rot = new Matrix4x4().rotateAbout(origin, cameraLeft, sc_amount);
		cameraUp.mul(rot);
		cameraDir.mul(rot);
		cameraLoc.mul(rot);
		updateCamera();
		}
	    else if (evt.target == scrollx)
		{
		rot = new Matrix4x4().rotateAbout(origin, cameraUp, -sc_amount);
		cameraLeft.mul(rot);
		cameraDir.mul(rot);
		cameraLoc.mul(rot);
		updateCamera();
		}
	    else if (evt.target == scrollz)
		{
		rot = new Matrix4x4().rotateAbout(origin, cameraDir, sc_amount);
		cameraLeft.mul(rot);
		cameraUp.mul(rot);
		updateCamera();
		}
	    else if (evt.target == scrollm)
		{
		cameraLoc.add(cameraDir.copy().scale(sc_amount/5));
		/*if (cameraLoc.magnitude()<150)
		    cameraLoc=cameraLoc.scale(150/cameraLoc.magnitude());*/
		updateCamera();
		}

	    redraw();
	    s.setValue(0);
	    return true;
	    }
	else return super.handleEvent(evt);
	}
    
    public void redraw()
	{
	vwcanvas.paint(vwcanvas.getGraphics());
	}
    
    public void addObject(VisualObject v)
	{
	vw.add(v);
	}

    public void addObject(VisualObject v, 
			  double x, double y, double z)
	{
	v.mul(new Matrix4x4().scale(0.0).move(x,y,z));  /* set to the origin, then move*/
	vw.add(v);
	}
    
    public void removeObjects()
	{
	vw.removeObjects();
	}
    }





class VwCanvas extends Canvas {
    VisualWorld vw;
    Image im;
    Graphics offscreen;
    int mouseDragX;

    public HitInterface target;

    public boolean handleEvent(Event evt)
	{
	if (evt.id==Event.MOUSE_DOWN)
	    {
	    target.doMouseEvent(evt.x,evt.y);
	    return true;
	    }
	return false;
	}

    public VwCanvas(VisualWorld vw)
    {
        this.vw = vw;
        resize(500, 200);
    }

    public void reshape(int x, int y, int w, int h)
    {
        super.reshape(x, y, w, h);

        try {
            im = createImage(w, h);
            offscreen = im.getGraphics();
        } catch (Exception e)  {
            // double-buffering not available
            offscreen = null;
        }
    }

    public void paint(Graphics g) {
        int w=size().width;
        int h=size().height;
        String msg;

        if (offscreen != null) {
            // double-buffering available
            vw.paint(offscreen, w, h);

            g.drawImage(im, 0, 0, this);
        } else  {
            // no double-buffering
            vw.paint(g, w, h);
        }
    }
}
