
package awwwesome.visualworld;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Color;
import java.util.Enumeration;
import neurodata.Colors;

/** A displayable single point in space.  This point can have a textual
  label and/or a visual dot representation when drawn on-screen.
 */
public class Point3D extends VisualObject {
    public Color color;
    public Color othercolor;
    Vector4 point;
    Vector4 eyepoint;
    public String text;
    public int size;
    public IntVector2 projected_point;	// Where am I displayed?
    public boolean projection_shown;	// Do I get displayed?


    /**
     Construct a Point3D with label t and drawn radius s.
     If s==0, the point is not drawn at display-time.  If
     t is "", no label is displayed.  These are independent items. */    
    public Point3D(String t,int s)
    {
    projected_point=new IntVector2();
        color = Color.black;
	color = Color.black;
	text=t;
        point = new Vector4();
	eyepoint = new Vector4();
	size=s;
	point.v[0]=0; point.v[1]=0; point.v[2]=0;
	eyepoint.v[0]=0; eyepoint.v[1]=0; eyepoint.v[2]=0;
    projection_shown=false;
    }



    /** Construct a Point3D with label t, but no dot to represent the point
      when drawn at display-time. if t is "", no label is displayed. */
    public Point3D(String t) {this(t,0); }



    /** Construct a Point3D with no label, and drawn radius s.
      If s==0, the point is not drawn at display-time. */
    public Point3D(int s) {this("",s); }



    /** Construct a Point3D with no label and no displayed dot. */
    public Point3D() {this("",0); }



    /** Set the color of the textual label */
    public void setOtherColor(Color c)
	{
	othercolor=c;
	}



    /** Set the color of the dot */
    public void setColor(Color c) {
        color = c;
    }


    /** Transform the point*/
    public VisualObject mul(Matrix4x4 m) {
       point.mul(m);
        return this;
    }

    
    /** Return the Z coordinate of the transformed point */
    public double getEyeZ() {
        return eyepoint.v[2];
    }



    /** Transform the point into eye coordinates */
    public void transformToEye(ViewTransformer viewTransformer) {
    projection_shown=false;  /* just in case */
	eyepoint= viewTransformer.transform(point);
    }



    public void project(Graphics g, ViewTransformer viewTransformer, double distance)
	{
	if (eyepoint.v[2]<distance) project(g,viewTransformer);
	}

    /** Project that sucker. */
    public void project(Graphics g, ViewTransformer viewTransformer) {
    
    /*System.out.println(eyepoint.v[2]);*/
    if (eyepoint.v[2]>=0) {projection_shown=false; return; }
    projection_shown=true;
    projected_point = viewTransformer.project(eyepoint);
    if (size!=0)
	{
	g.setColor(color);
	if (size==1) g.drawLine(projected_point.v[0],projected_point.v[1],
				projected_point.v[0],projected_point.v[1]);
	else g.fillOval(projected_point.v[0]-size/2,projected_point.v[1]-size/2,size,size);
	g.setColor(Colors.labelColor);
	g.drawString(text,projected_point.v[0]+size/2,projected_point.v[1]-size/2);
	}
    else { g.setColor(othercolor); g.drawString(text,projected_point.v[0],projected_point.v[1]); }
    }


    public void print() {
        String s = "Point[" + point + "," + size + ",\"" + text + "\"]";
        System.out.println(s);
    }
}


