/*
 * Copyright (c) 1996 Awwwesome Webware. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. 
 *
 * AWWWESOME WEBWARE MAKES NO REPRESENTATIONS OR WARRANTIES 
 * ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE, OR NON-INFRINGEMENT. AWWWESOME WEBWARE SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A 
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE 
 * OR ITS DERIVATIVES.
 */
package awwwesome.visualworld;

import java.awt.Color;

public class Polygon3D {
    public Color color;

    public int n;
    int vCount;
    public Vector4[] verticies;

    public Polygon3D(Color color, int vCount) {
        this.color = color;

        this.vCount = vCount;
    
        verticies = new Vector4[vCount];
        n=0;
    }

    public void addPoint(Vector4 point) {
        verticies[n++] = point;
    }

    public String toString() {
        String s = "(Polygon3d)\n";


        for(int i=0; i<n; ++i) {
            s += "  " + verticies[i].toString() + "\n";            
        }

        return s;        
    }

}