/*
 * Copyright (c) 1996 Awwwesome Webware. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. 
 *
 * AWWWESOME WEBWARE MAKES NO REPRESENTATIONS OR WARRANTIES 
 * ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE, OR NON-INFRINGEMENT. AWWWESOME WEBWARE SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A 
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE 
 * OR ITS DERIVATIVES.
 */
package awwwesome.visualworld;

import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Color;

public class Pyramid extends Polyhedron {
    static int[][] faces= new int[5][4];

    static {
        //        4          Y   
        //        *          |  /
        //                   | /
        //                   |/
        //      1- -2   -----+------ X
        //     /   /        /|
        //    0---3        / |
        //                /  |
        //               Z
        //
        // The origin is at the center of the cube.
        // Positive Z is into the page.
        //
        //
        faces[0][0] = 0;
        faces[0][1] = 3;
        faces[0][2] = 2;
        faces[0][3] = 1;
    
        faces[1][0] = 0;
        faces[1][1] = 4;
        faces[1][2] = 3;

        faces[2][0] = 3;
        faces[2][1] = 4;
        faces[2][2] = 2;

        faces[3][0] = 2;
        faces[3][1] = 4;
        faces[3][2] = 1;

        faces[4][0] = 1;
        faces[4][1] = 4;
        faces[4][2] = 0;
    }
    
    public Pyramid(double w) {
        super(5);

        double w2 = w/2;

        points[0].v[0] = -w2; points[0].v[1] = -w2; points[0].v[2] =  w2;
        points[1].v[0] = -w2; points[1].v[1] = -w2; points[1].v[2] = -w2;
        points[2].v[0] =  w2; points[2].v[1] = -w2; points[2].v[2] = -w2;
        points[3].v[0] =  w2; points[3].v[1] = -w2; points[3].v[2] =  w2;
        points[4].v[0] =   0; points[4].v[1] =  w2; points[4].v[2] =   0;
    }

    public Pyramid() {
        this(1.f);    
    }

    public int getPolygonCount() {
        return 5;
    }

    public Polygon3D transformPolygonToEye(int f, ViewTransformer viewTransformer) {
        Polygon3D poly = new Polygon3D(color, 4);

        poly.addPoint(viewTransformer.transform(points[faces[f][0]]));
        poly.addPoint(viewTransformer.transform(points[faces[f][1]]));
        poly.addPoint(viewTransformer.transform(points[faces[f][2]]));
        if (f == 0)
            poly.addPoint(viewTransformer.transform(points[faces[f][3]]));

        return poly;
    }
}


