/*
 * Copyright (c) 1996 Awwwesome Webware. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. 
 *
 * AWWWESOME WEBWARE MAKES NO REPRESENTATIONS OR WARRANTIES 
 * ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE, OR NON-INFRINGEMENT. AWWWESOME WEBWARE SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A 
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE 
 * OR ITS DERIVATIVES.
 */
package awwwesome.visualworld;


public class Vector4 extends Vectorf {
    public Vector4() {
        super(4);
        v[0] = v[1] = v[2] = 0;
        v[3] = 1;
    }

    public Vector4(Vector4 vec) {
        super((Vectorf)vec);
    }

    public Vector4(double x, double y, double z, double w) {
        super(4);
        v[0] = x;
        v[1] = y;
        v[2] = z;
        v[3] = w;
    }

    public Vector4 add(Vector4 vec) {
        return (Vector4)super.addf((Vectorf)vec);
    }

    public Vector4 sub(Vector4 vec) {
        return (Vector4)super.subf((Vectorf)vec);
    }

    public Vector4 neg() {
        return (Vector4)super.negf();
    }
    
    public Vector4 scale(double s) {
        return (Vector4)super.scalef(s);
    }

    public Vector4 copy() {
        return (Vector4)new Vector4(this);
    }

    public double magnitude() {
        double m;

        m = Math.sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);

        return (double)m;
    }


    public double dot(Vector4 vec) {
        return super.dot((Vectorf)vec);
    }

    public Vector4 cross(Vector4 vec) {
        Vector4 r = new Vector4();

        r.v[0] = v[1] * vec.v[2] - v[2] * vec.v[1];
        r.v[1] = v[2] * vec.v[0] - v[0] * vec.v[2];
        r.v[2] = v[0] * vec.v[1] - v[1] * vec.v[0];

        for(int i=0; i<4; ++i)
            v[i] = r.v[i];

        return this;
    }

    public Vector4 mul(Matrix4x4 m) {
        double nv[] = new double[4];

        for(int i=0; i<4; ++i) {
            nv[i] = 0;
            for(int j=0; j<4; ++j) {
                nv[i] = nv[i] + v[j] * m.v[i][j];
            }
        }
        for(int i=0; i<4; ++i)
            v[i] = nv[i];

        return this;
    }
}

