/*
 * Copyright (c) 1996 Awwwesome Webware. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. 
 *
 * AWWWESOME WEBWARE MAKES NO REPRESENTATIONS OR WARRANTIES 
 * ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE, OR NON-INFRINGEMENT. AWWWESOME WEBWARE SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A 
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE 
 * OR ITS DERIVATIVES.
 */
package awwwesome.visualworld;

public class Vectorf {
    public int n;
    public double v[];


    Vectorf(int n) {
        this.n = n;

        v = new double[n];
    }

    Vectorf(Vectorf vec) {
        this(vec.n);

        for(int i=0; i<n; ++i)
            v[i] = vec.v[i];

    }

    Vectorf addf(Vectorf vec) {
        for(int i=0; i<n-1; ++i) {
            v[i] += vec.v[i];
        }

        return this;
    }

    Vectorf subf(Vectorf vec) {
        for(int i=0; i<n-1; ++i) {
            v[i] -= vec.v[i];
        }

        return this;
    }

    Vectorf negf() {
        for(int i=0; i<n-1; ++i) {
            v[i] = -v[i];
        }

        return this;
    }

    Vectorf scalef(double s) {
        for(int i=0; i<n-1; ++i) {
            v[i] *= s;
        }

        return this;
    }

    Vectorf copyf() {
        return new Vectorf(this);
    }

    double dot(Vectorf vec) {
        double d = 0;

        for(int i=0; i<n; ++i) {
            d += v[i] * vec.v[i];
        }
        return d;
    }

    public String toString() {
        String s;
        
        
        s = "[";
        for(int i=0; i<n; ++i) {
            s = s + v[i] + " ";
        }
        s = s + "]";            

        return s;
    }

    public void print() {
        System.out.println(toString());
    }
}
