/*
 * Copyright (c) 1996 Awwwesome Webware. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. 
 *
 * AWWWESOME WEBWARE MAKES NO REPRESENTATIONS OR WARRANTIES 
 * ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE, OR NON-INFRINGEMENT. AWWWESOME WEBWARE SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A 
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE 
 * OR ITS DERIVATIVES.
 */
package awwwesome.visualworld;


public class ViewTransformer {
    Matrix4x4 viewMatrix;               // View matrix.
    double screenDistance;               // Distance from eye to screen.
    double screenHeight;                 // Height of screen.
    double k;                            // -screenDistance/screenHeight * h2.
    int w2, h2;                         // Display half width and half height.


    public ViewTransformer(Matrix4x4 m, int w2, int h2) {
        viewMatrix = m.copy();
        this.w2 = w2;
        this.h2 = h2;
    }

    public void setScreenDistanceAndHeight(double d, double h) {
        screenDistance = d;
        screenHeight = h;

        k = -screenDistance / screenHeight * h2;
    }

    public Vector4 transform(Vector4 vin) {

        /* 
         * World to eye coordinate transformation
         */
        Vector4 vout = ((Vector4)(vin.copy())).mul(viewMatrix);


        /*
         * Perspective transformation
         */
        double z = vout.v[2];
        if (z == 0.0f) z = 1.0f;

        vout.v[0] = vout.v[0] / z * k;
        vout.v[1] = vout.v[1] / z * k;

        return vout;
    }

    public IntVector2 project(Vector4 p) {
        return new IntVector2((int)(p.v[0]) + w2, h2 - (int)(p.v[1]));
    }
}
