/*
 * Copyright (c) 1996 Awwwesome Webware. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. 
 *
 * AWWWESOME WEBWARE MAKES NO REPRESENTATIONS OR WARRANTIES 
 * ABOUT THE SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE, OR NON-INFRINGEMENT. AWWWESOME WEBWARE SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A 
 * RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE 
 * OR ITS DERIVATIVES.
 */
package awwwesome.visualworld;

import java.awt.Graphics;
import java.awt.Color;

/**
 * A visual object is a member of a visual world.
 *  
 * <ul>
 *   <li>It occupies a location in the visual world as defined by its world coordinates.
 *   <li>It can be moved in this world using the mul() method.
 *   <li>VisualWorld will prepare a VisualObject for viewing in two steps:
 *   <ul>
 *     <li>tranformToEye() will map the world coordinates to eye coordinates.
 *     <li>project() will then project the 3D coordinates to the screen
 *         and draw the object.
 *   </ul>
 *   <li> In between the two transformations VisualWorld will call
 *        getEyeZ() to get a point contained by or on the object. 
 *        This value will be used to sort the objects in the world by
 *        Z depth.  After sorting,
 *        the objects can then be painted in Z order to produce the final
 *        scene.
 * </ul>
 *
 * The actual transformations which occur in transform() and project() 
 * are determined by the ViewTransformer object passed to them.
 *
 * @see ViewTransformer
 * @see Polyhedron
 * @see Cube
 * @see Pyramid
 */
public abstract class VisualObject {
    /**
     * Sets the objects overall color.
     */
    public abstract void setColor(Color color);
    public abstract void setOtherColor(Color color);

   /**
    * Used to move the object in world cooridinates.
    */
    public abstract VisualObject mul(Matrix4x4 mat);

    public       abstract void transformToEye(ViewTransformer viewTransformer);
    public       abstract double getEyeZ();
    public       abstract void project(Graphics g, ViewTransformer viewTransformer);
    public       abstract void project(Graphics g, ViewTransformer viewTransformer,double origin_distance); /* a hack for clipping */
};
