package neurodata;
import java.awt.*;
import java.lang.*;

/** A simple dialog box class.  This box isn't modal, and any number of them can be thrown up.
  The reason it's not modal is primarily that some JVMs bomb with modal dialogs (namely,
  SGI's junk). */

public class DialogBox extends Dialog
    {
    public static int dialog_result_okay =1;
    public static int dialog_result_cancel =2;
    public static int dialog_result_other =3;
    public Button okay;
    public Button cancel;
    public Button other;
    public DialogBoxResponse d;

    public DialogBox(DialogBoxResponse delegate, Frame parent, String title, String text, 
		     String okaybutton)
	{
	this(delegate,parent,title,text,okaybutton,null,null);
	}
    public DialogBox(DialogBoxResponse delegate, Frame parent, String title, String text, 
		     String okaybutton, String cancelbutton)
	{
	this(delegate,parent,title,text,okaybutton,cancelbutton,null);
	}
    public DialogBox(DialogBoxResponse delegate, Frame parent, String title, String text, 
		     String okaybutton, String cancelbutton, String otherbutton)
	{
	super(parent,title,/*true*/ false 
	      /* right now it looks like modal dialogs result in bad Java bombs on monet */
	      );
	GridBagConstraints gbc;
	GridBagLayout gbl = new GridBagLayout();
	setLayout(gbl);

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=0; gbc.gridwidth=gbc.REMAINDER; gbc.gridheight=1;
	gbc.fill=gbc.HORIZONTAL; gbc.anchor=gbc.CENTER;
	gbc.weightx=1.0; gbc.weighty=1.0;
	Label l = new Label(text, Label.CENTER);
	resize(400,100);
	gbl.setConstraints(l,gbc);
	add(l);
	
	if (okaybutton!=null)
	    {
	    gbc = new GridBagConstraints();
	    gbc.gridx=0; gbc.gridy=1; gbc.gridwidth=1; gbc.gridheight=1;
	    gbc.fill=gbc.NONE; gbc.anchor=gbc.CENTER;
	    gbc.weightx=1.0; gbc.weighty=1.0;
	    okay = new Button(okaybutton);
	    gbl.setConstraints(okay,gbc);
	    add(okay);
	    }
	if (cancelbutton!=null)
	    {
	    gbc = new GridBagConstraints();
	    gbc.gridx=1; gbc.gridy=1; gbc.gridwidth=1; gbc.gridheight=1;
	    gbc.fill=gbc.NONE; gbc.anchor=gbc.CENTER;
	    gbc.weightx=1.0; gbc.weighty=1.0;
	    cancel = new Button(cancelbutton);
	    gbl.setConstraints(cancel,gbc);
	    add(cancel);
	    }
	if (otherbutton!=null)
	    {
	    gbc = new GridBagConstraints();
	    gbc.gridx=1; gbc.gridy=1; gbc.gridwidth=1; gbc.gridheight=1;
	    gbc.fill=gbc.NONE; gbc.anchor=gbc.CENTER;
	    gbc.weightx=1.0; gbc.weighty=1.0;
	    other = new Button(otherbutton);
	    gbl.setConstraints(other,gbc);
	    add(other);
	    }

	d=delegate;
	}

    public void showDialog()
	{
	show();
	}

    public boolean handleEvent(Event evt) 
	{
	if (evt.target == okay && evt.id==Event.ACTION_EVENT && evt.target!=null)
	    {
	    hide(); dispose();
	    d.dialogResult(this,dialog_result_okay);
	    return true;
	    }
	else if (evt.target == cancel && evt.id==Event.ACTION_EVENT && evt.target!=null)
	    {
	    hide(); dispose();
	    d.dialogResult(this,dialog_result_cancel);
	    return true;
	    }
	else if (evt.target == other && evt.id==Event.ACTION_EVENT && evt.target!=null)
	    {
	    hide(); dispose();
	    d.dialogResult(this,dialog_result_other);
	    return true;
	    }
	else if (evt.id == Event.WINDOW_DESTROY)
	    {
	    if (cancel!=null)	// by default, window-closes cancel
		{
		hide(); dispose();
		d.dialogResult(this,dialog_result_cancel);
		return true;
		}
	    else		// if only one button, well, that's it.
		{
		hide(); dispose();
		d.dialogResult(this,dialog_result_okay);
		return true;
		}
	    }
	else return super.handleEvent(evt);
	}
    }
