package neurodata;
import java.awt.*;
import java.lang.*;
import java.util.*;

/** The dialog box in charge of choosing synapse display options.  Owned by Cubes.java. */

public class DisplaySynapses extends Frame
    {
    Choice synapse;
    Checkbox display_label;
    Button doit;
    DisplaySynapseInterface delegate;

    public DisplaySynapses(DisplaySynapseInterface _delegate)
	{
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc;
	setTitle("Synapse Display");
	setLayout(gbl);
	Label l;

	// FOURTH COLUMN
	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=0; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	l=new Label("Show:");
	gbl.setConstraints(l,gbc);
	add(l);

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=1; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	synapse=new Choice();
	gbl.setConstraints(synapse,gbc);
	
	synapse.addItem("Nothing");
	synapse.addItem("Incoming Chemical Synapses");
	synapse.addItem("Outgoing Chemical Synapses");
	synapse.addItem("Gap Junctions");
	synapse.select("Nothing");
	add(synapse);
	
	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=2; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	display_label = new Checkbox("Label With Synapse Count");
	gbl.setConstraints(display_label,gbc);
	add(display_label);
	
	// A flexible panel goes here
	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=3; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.VERTICAL; gbc.anchor=gbc.CENTER;
	gbc.weightx=1.0; gbc.weighty=1.0;
	Panel pp=new Panel();
	gbl.setConstraints(pp,gbc);
	add(pp);

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=4; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.HORIZONTAL; gbc.anchor=gbc.SOUTH;
	gbc.weightx=1.0; gbc.weighty=0.0;
	doit=new Button("Set");
	gbl.setConstraints(doit,gbc);
	add(doit);
	
	delegate=_delegate;
	pack();
	resize(250,300);
	}

    public boolean handleEvent(Event evt)
	{
	if (evt.target==doit && evt.id==Event.ACTION_EVENT)
	    {
	    delegate.setSynapseInfo(synapse.getSelectedIndex(),  // must be same order as CellPoint static ints
				    display_label.getState());
	    return true;
	    }
	else if (evt.id==Event.WINDOW_DESTROY)
	    {
	    hide();		// DON'T destroy; it's expensive to recreate me!
	    return true;
	    }
	else return super.handleEvent(evt);
	}

    }
