package neurodata;
import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;
import java.lang.*;

/** FindPanel produces a Find Cell panel with a sorted list of cell names, and
  lets the user select a given cell or at least determine in what time frame
  it appears. */

public class FindPanel extends Frame implements DialogBoxResponse, SortInterface
    {
    Button go;
    List cells;

    FindInterface find;
    
    public boolean greaterThan(Object o1, Object o2)
	{
	return (((String)o1).compareTo((String)o2) > 0);
	}

    public FindPanel(Enumeration _cells, FindInterface f)
	{ 
	setTitle("Find a Cell");
	setLayout(new BorderLayout());
	go = new Button("Find");
	add("South",go);
	
	Sorter s=new Sorter();
	while(_cells.hasMoreElements())
	    s.addElement(((Cell)(_cells.nextElement())).official_name);

	s.sort(this);
	cells = new List(s.size(),false);
	for(int x=0;x<s.size();x++)
	    {
	    cells.addItem((String)(s.elementAt(x)));
	    }
	add("Center",cells);
	resize(200,300);
	find=f;
	}

    public void setFinder(FindInterface f)
	{
	find=f;
	}

    public void dialogResult(DialogBox sender,int result) { }

    public boolean handleEvent(Event evt)
	{
	if (evt.target==go && evt.id==Event.ACTION_EVENT)
	    {
	    if (find!=null)
		{
		String result;
		String s=cells.getSelectedItem();
		if (s==null)
		    (new DialogBox(this,this,"Nothing Selected",
				"You need to select something to find it!","Oops")).showDialog();
		else if ((result=find.doFind(s))!=null)
		    (new DialogBox(this,this,"Couldn't Find Cell",
				result,"Okay")).showDialog();
		}
	    return true;
	    }
	else if (evt.id==Event.WINDOW_DESTROY)
	    {
	    hide();		// DON'T destroy--it's expensive to create me!
	    return true;
	    }
	else return super.handleEvent(evt);
	}
    }
