package neurodata.GL;

import neurodata.*;
import javax.vecmath.*;
import java.awt.*;
import javax.media.j3d.*;
import java.util.*;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.behaviors.mouse.*;
import com.sun.j3d.utils.image.TextureLoader;

/** GLCellPoint is the object responsible for rendering the sphere representing the cell
  in the Java3D GLDisplay.  GLCellPoints contain a PickSphere (the sphere itself),
  the CellPoint corresponding to this GLCellPoint, and the Cubes object (for selecting).
*/

public class GLCellPoint extends Object
    {

    public static Appearance appearance0;		// selected cells	
    public static Appearance appearance1;		// normal cells
    public static Appearance appearance2;		// alternate cells

    /** increase this to make the spheres look nicer, decrease it to render faster. */
    public static int numSphereDivisions = 15;
    public PickSphere sphere;
    public CellPoint cellpoint;
    public Cubes selector;


    /** This static method should be called exactly once to set up the various appearance
      features of normal, selected, and highlighted cells.  We could have set this as just
      a static{ }, of course, but this doesn't work as it needs to set up some stuff that's
      not ready by the time static{ } methods are called in some JVMs.  :-(
      */

    public static void setupClass(Component comp)
	{
	// Transparency.  Transparency is cool, but on many Java3D
	// environments (including in particular Solaris), it doesn't work
	// right, resulting in cells that are rendered in the wrong order.  So
	// right now, the attributes are TransparenceyAttributes.NONE.  But later
	// you may want to change this to TransparencyAttributes.NICEST when Sun
	// fixes their bugs.  It'll look much cooler.

	TransparencyAttributes ta = new TransparencyAttributes(TransparencyAttributes.NICEST,0.1f);
	

	// Surface for SELECTED CELLS

	Color3f ambientColor0  =new Color3f(0.3f,0.7f,0.3f);
	Color3f emissiveColor0 =new Color3f(0.0f,0.0f,0.0f);
	Color3f diffuseColor0  =new Color3f(0.4f,0.7f,0.3f);
	Color3f specularColor0 =new Color3f(0.2f,0.2f,0.2f);
	float shininess0 = 0.1f;
	Material material0 = new Material(ambientColor0, emissiveColor0, diffuseColor0, specularColor0, shininess0);
	material0.setLightingEnable(true);
	appearance0 = new Appearance();
	appearance0.setTransparencyAttributes(ta);
	
	// Here, you can have the selected cell be green or instead choose to have
	// it wrapped with a (admittedly hastily-put-together) "Sony.gif".
	// By the way, so people don't ask my what "It's a...Sony" means,
	// in Japan that's the current Sony slogan.
	
	 appearance0.setMaterial(material0);     // makes it green
	//appearance0.setTexture(new TextureLoader("Sony.gif",comp).getTexture());  // makes it "Sony"


	// Surface for ORDINARY CELLS

	Color3f ambientColor1  =new Color3f(0.3f,0.3f,0.7f);
	Color3f emissiveColor1 =new Color3f(0.0f,0.0f,0.0f);
	Color3f diffuseColor1  =new Color3f(0.3f,0.4f,0.7f);
	Color3f specularColor1 =new Color3f(0.2f,0.2f,0.2f);
	float shininess1 = 0.1f;
	Material material1 = new Material(ambientColor1, emissiveColor1, diffuseColor1, specularColor1, shininess1);
	material1.setLightingEnable(true);
	appearance1 = new Appearance();
	appearance1.setTransparencyAttributes(ta);
	appearance1.setMaterial(material1);
	


	// Surface for HIGHLIGHTED CELLS

	Color3f ambientColor2  =new Color3f(0.7f,0.3f,0.3f);
	Color3f emissiveColor2 =new Color3f(0.0f,0.0f,0.0f);
	Color3f diffuseColor2  =new Color3f(0.8f,0.4f,0.3f);
	Color3f specularColor2 =new Color3f(0.2f,0.2f,0.2f);
	float shininess2 = 0.1f;
	Material material2 = new Material(ambientColor2, emissiveColor2, diffuseColor2, specularColor2, shininess2);
	material2.setLightingEnable(true);
	appearance2 = new Appearance();
	appearance2.setTransparencyAttributes(ta);
	appearance2.setMaterial(material2);
	
	}
    

    /** Sets the GLCellPoint color to either Colors.selectedCellColor, Colors.cellColor, or Colors.alternateCellColor.  The GLCellPoint responds by setting its appearance attributes accordingly. */

    public void setColor(Color c)
	{
        if (c==Colors.selectedCellColor)
	    sphere.setAppearance(appearance0);
	else if (c==Colors.cellColor)
	    sphere.setAppearance(appearance1);
	else // (c==Colors.alternateCellColor)
	    sphere.setAppearance(appearance2);
	}


    public GLCellPoint(float radius,Color c, Cubes cubes)
	{
	Appearance a;
	if (c==Colors.selectedCellColor) a=appearance0;
	else if (c==Colors.cellColor) a=appearance1;
	else a=appearance2;
	sphere=	new PickSphere(radius,Sphere.GENERATE_NORMALS | Sphere.GENERATE_TEXTURE_COORDS | Sphere.ENABLE_APPEARANCE_MODIFY, numSphereDivisions,a,this);
	selector=cubes;
	sphere.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
	sphere.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
	}

    }
