
package neurodata.GL;

import neurodata.*;
import javax.vecmath.*;
import java.awt.*;
import javax.media.j3d.*;
import java.util.*;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.behaviors.mouse.*;

/** A GLDisplay displays cells in a javax.media.j3d.Canvas3D, a simple Java3D display
  mechanism.  As GLDisplays are optional additions to the neurodata system, they do
  a lot of stuff on their own which would ordinarily be handled by the Cubes and Cells
  classes. */

public class GLDisplay extends javax.media.j3d.Canvas3D
    {
    float volMultScale=1.0f;
    float disMultScale=0.05f;
    BranchGroup top;
    BranchGroup objRoot;
    SimpleUniverse universe;
    public static boolean supportingGL = true;   // this is the real thing, not a stub


    /** Returns a new GLDisplay.  The reason behind this function is to make it
	possible to create a GLDisplay without knowing what a GraphicsConfiguration
	is (they're not available in older versions of Java); this allows us to
	replace the GLDisplay with a stub for older systems that don't know nothin'
	'bout Java3D.
	*/

    public static GLDisplay newGLDisplay()
	{
	return new GLDisplay(null);
	}


    public GLDisplay(java.awt.GraphicsConfiguration graphicsConfiguration)
	{
	super(graphicsConfiguration);
	top = new BranchGroup();
	objRoot = new BranchGroup();
	objRoot.setCapability(Group.ALLOW_CHILDREN_EXTEND);
	objRoot.setCapability(Group.ALLOW_CHILDREN_READ);
	objRoot.setCapability(Group.ALLOW_CHILDREN_WRITE);
	objRoot.setCapability(BranchGroup.ALLOW_DETACH);
	top.setCapability(Group.ALLOW_CHILDREN_EXTEND);
	top.setCapability(Group.ALLOW_CHILDREN_READ);
	top.setCapability(Group.ALLOW_CHILDREN_WRITE);
	top.setCapability(BranchGroup.ALLOW_DETACH);
	top.addChild(objRoot);
	universe = new SimpleUniverse(this);
	universe.getViewingPlatform().setNominalViewingTransform();
	universe.addBranchGraph(top);
	GLCellPoint.setupClass(this);
	}


    /** Draw a given scene for a known timestamp, given Cells and Cubes to work with. */

    public void formScene(int timestamp, Cells cc, Cubes cubes)
	{
	double[]xyz=new double[3];
	xyz[0]=1000;
	Enumeration cells=cc.cell_dictionary.elements();
	
	objRoot = new BranchGroup();
	objRoot.setCapability(Group.ALLOW_CHILDREN_EXTEND);
	objRoot.setCapability(Group.ALLOW_CHILDREN_READ);
	objRoot.setCapability(Group.ALLOW_CHILDREN_WRITE);
	objRoot.setCapability(BranchGroup.ALLOW_DETACH);
	
	TransformGroup objScale = new TransformGroup();
	Transform3D t3d = new Transform3D();
	t3d.setScale(0.4);
	objScale.setTransform(t3d);
	objRoot.addChild(objScale);
	
	BoundingSphere bounds =
	    new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
	
	Background bg = new Background(new Color3f(0.0f,0.0f,0.0f));
	bg.setApplicationBounds(bounds);
	objScale.addChild(bg);
	
	
	// Create the transform node
	TransformGroup transformGroup = new TransformGroup();
	transformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
	transformGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	objScale.addChild(transformGroup);
	
	// Create the drag behavior node
	MouseRotate behavior = new MouseRotate();
	behavior.setTransformGroup(transformGroup);
	transformGroup.addChild(behavior);
	behavior.setSchedulingBounds(bounds);
	
	// Create the zoom behavior node
	MouseZoom behavior2 = new MouseZoom();
	behavior2.setTransformGroup(transformGroup);
	transformGroup.addChild(behavior2);
	behavior2.setSchedulingBounds(bounds);
	
	// Create the translate behavior node
	MouseTranslate behavior3 = new MouseTranslate();
	behavior3.setTransformGroup(transformGroup);
	transformGroup.addChild(behavior3);
	behavior3.setSchedulingBounds(bounds);
	
	// Create the Pick behavior node
	PickSelectSphereBehavior behavior4 = new PickSelectSphereBehavior(this,objRoot,bounds);
	behavior4.selector=cubes;
	objRoot.addChild(behavior4);

	// add some lights
	AmbientLight ambientLight=new AmbientLight(true,new Color3f(1.0f,1.0f,1.0f));
	objScale.addChild(ambientLight);
	ambientLight.setInfluencingBounds(bounds);
	DirectionalLight directionalLight=new DirectionalLight(true,new Color3f(1.0f,1.0f,1.0f),
							       new Vector3f(0.0f,0.0f,-1000.0f));
	objScale.addChild(directionalLight);
	directionalLight.setInfluencingBounds(bounds);
	
	
	while(cells.hasMoreElements())
	    {
	    Cell cell=(Cell)cells.nextElement();
	    if (cell.cp.displayed && cell.cp.display_when_possible && cell.getLocation(timestamp,xyz))
		{
		if (!(xyz[0]==-30 && xyz[1]==-20 && xyz[2]==-20))
		    {
		    Transform3D t=new Transform3D();
		    Vector3d pos= new Vector3d(xyz[0]*disMultScale,xyz[1]*disMultScale,xyz[2]*disMultScale);
		    t.set(pos);
		    TransformGroup trans=new TransformGroup(t);
		    transformGroup.addChild(trans);
		    /* add object and color */
		    
		    cell.cp.glcellpoint=new GLCellPoint(cell.getRadius(timestamp)*volMultScale,cell.cp.color,cubes);
		    cell.cp.glcellpoint.cellpoint=cell.cp;
		    trans.addChild(cell.cp.glcellpoint.sphere);
		    }
		}
	    }
	
	this.stopRenderer();
	getView().setDepthBufferFreezeTransparent(false);

	objRoot.compile();
	if (top.numChildren() > 0) top.removeChild(0);  // should be objRoot
	top.addChild(objRoot);

	this.startRenderer();
	}
    
    }

