package neurodata.GL;

import neurodata.*;
import com.sun.j3d.utils.behaviors.picking.*;
import com.sun.j3d.utils.geometry.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;

/** This class is a specialization of PickMouseBehavior which selects the
  cell that the user clicks on.  It overrides some stuff in PickMouseBehavior
  making it possible to intercept not just mouse presses and drags, but
  actual clicks.  Unfortunately, bugs in Java3D make picking unreliable.  :-(
*/

public class PickSelectSphereBehavior extends PickMouseBehavior
    {
    public Cubes selector;

    public PickSelectSphereBehavior(javax.media.j3d.Canvas3D canvas,
				    javax.media.j3d.BranchGroup root,
				    javax.media.j3d.Bounds bounds)
	{
	super(canvas,root,bounds); 
	setSchedulingBounds(bounds);
	}
    
    public PickSphere cellpoint; 
    
    public void updateScene(int xpos, int ypos)
	{
	// okay, we now tell the sphere in question that it's been picked.
	// hopefully, the object *is* a sphere!
	
       Primitive closest = (Primitive)(pickScene.pickNode(pickScene.pickClosest(xpos, ypos),PickObject.PRIMITIVE));
	
	if (closest instanceof PickSphere)
	    {
	    PickSphere ps = (PickSphere)closest;
	    ps.select();
	    return;
	    }
	}
    
    
    /* The following code overrides Sun's default mechanism for PickMouseBehavior,
       which stupidly does a mouse pick whenever you drag or click.  Duh!  We
       just want clicking. 
       */
    
    public void initialize() 
	{
	conditions = new WakeupCriterion[1];
	conditions[0] = new WakeupOnAWTEvent(MouseEvent.MOUSE_CLICKED);
	wakeupCondition = new WakeupOr(conditions);
	
	wakeupOn(wakeupCondition);
	}
    
    
        /* The following code overrides Sun's default mechanism for PickMouseBehavior,
       which stupidly does a mouse pick whenever you drag or click.  Duh!  We
       just want clicking. 
       */
    

    private void processSelectMouseEvent(MouseEvent evt)
	{
	buttonPress = false;
	
	if (evt.getID()==MouseEvent.MOUSE_CLICKED) 
	    {
	    buttonPress = true;
	    return;
	    }
	}

        /* The following code overrides Sun's default mechanism for PickMouseBehavior,
       which stupidly does a mouse pick whenever you drag or click.  Duh!  We
       just want clicking. 
       */
    

    public void processStimulus (Enumeration criteria) 
	{
	WakeupCriterion wakeup;
	AWTEvent[] evt = null;
	int xpos = 0, ypos = 0;
	
	while(criteria.hasMoreElements()) 
	    {
	    wakeup = (WakeupCriterion)criteria.nextElement();
	    if (wakeup instanceof WakeupOnAWTEvent)
		evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
	    }
	
	if (evt[0] instanceof MouseEvent)
	    {
	    MouseEvent mevent = (MouseEvent) evt[0];
	    
	    processSelectMouseEvent(mevent);
	    xpos = mevent.getPoint().x;
	    ypos = mevent.getPoint().y;
	    }
		
	if (buttonPress) updateScene(xpos, ypos);
	wakeupOn (wakeupCondition);
	}
    }
