package neurodata;
import java.awt.*;
import java.lang.*;
import java.util.*;


/** Highlight is a panel that lets the user choose whether to hilight neurons, descendents of some particular cell, members of a given cell group, expression pattern, or cell fate, or nothing at all.  Highlighted cells are shown in pink, nonhighlighted items are shown in blue, or (if the user so decides) not at all.  The user can also request that highlighted items display their labels (usually a bad idea -- there are a lot of cells out there).  And lastly, the user can chose to display or not display the cells Z2 and Z3, (the "zcells"), which don't have descendents and so appear
huge volume-wise (they just don't die).  In reality, Z2 and Z3 are the ancestors of the germ line,
so not displaying them is probably a Good Idea.
*/

public class Highlight extends Frame implements SortInterface, DialogBoxResponse
    {
    java.awt.List cells;
    java.awt.List groups;
    java.awt.List patterns;
    java.awt.List fates;
    Choice highlight;
    Checkbox display_others;
    Checkbox display_label;
    Checkbox display_zcells;
    Button doit;
    HighlightInterface delegate;

    public static int HIGHLIGHT_NEURONS = 0;
    public static int HIGHLIGHT_DESCENDENTS = 1;
    public static int HIGHLIGHT_GROUPS = 2;
    public static int HIGHLIGHT_PATTERNS = 3;
    public static int HIGHLIGHT_FATES = 4;
    public static int HIGHLIGHT_NOTHING = 5;

    public boolean greaterThan(Object o1, Object o2)
	{
	return (((String)o1).compareTo((String)o2) > 0);
	}

    public Highlight(Enumeration _cells, Enumeration _groups, Enumeration _patterns, Enumeration _fates, HighlightInterface _delegate)
	{
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc;
	setTitle("Highlight Cells");
	Sorter s=new Sorter();
	
	/* THIS will take a long time.  The Java AWT Sucks.  Big Time. */

	while(_cells.hasMoreElements())
	    s.addElement(((Cell)(_cells.nextElement())).official_name);
	s.sort(this);
	cells = new java.awt.List(s.size(),false);
	for(int x=0;x<s.size();x++)
	    cells.addItem((String)(s.elementAt(x)));

	s.removeAllElements();
	while(_groups.hasMoreElements())
	    s.addElement(((CellGroup)(_groups.nextElement())).name);
	s.sort(this);
	groups = new java.awt.List(s.size(),false);
	for(int x=0;x<s.size();x++)
	    groups.addItem((String)(s.elementAt(x)));

	s.removeAllElements();
	while(_patterns.hasMoreElements())
	    s.addElement(((ExpressionPattern)(_patterns.nextElement())).name);
	s.sort(this);
	patterns = new java.awt.List(s.size(),false);
	for(int x=0;x<s.size();x++)
	    patterns.addItem((String)(s.elementAt(x)));

	s.removeAllElements();
	while(_fates.hasMoreElements())
	    s.addElement(((Fate)(_fates.nextElement())).name);
	s.sort(this);
	fates = new java.awt.List(s.size(),false);
	for(int x=0;x<s.size();x++)
	    fates.addItem((String)(s.elementAt(x)));

	/* Done with ultra-long thingy */

	/* unfortunately, GridBagLayout seems to have trouble with Lists,
	   displaying them in all sorts of weird ways.  So we'll have to
	   do the multi-panel mess instead.  Dang. */


	Label l;

	// FIRST COLUMN
	Panel p1=new Panel();
	p1.setLayout(new BorderLayout());
	l=new Label("Cells");
	p1.add("North",l);
	p1.add("Center",cells);

	// SECOND COLUMN
	Panel p2=new Panel();
	p2.setLayout(new BorderLayout());
	l=new Label("Cell Groups");
	p2.add("North",l);
	p2.add("Center",groups);

	// THIRD COLUMN
	Panel p3=new Panel();
	p3.setLayout(new BorderLayout());
	l=new Label("Expression Patterns");
	p3.add("North",l);
	p3.add("Center",patterns);

	// THIRD AND ONE HALF COLUMN
	Panel p0=new Panel();
	p0.setLayout(new BorderLayout());
	l=new Label("Cell Fates");
	p0.add("North",l);
	p0.add("Center",fates);

	// GROUP COLUMNS P1 THROUGH P3  -> P4
	Panel p4=new Panel();
	p4.setLayout(new GridLayout(1,3));
	p4.add(p1);  p4.add(p2);  p4.add(p3);  p4.add(p0);

	// FOURTH COLUMN
	Panel p5=new Panel();
	p5.setLayout(gbl = new GridBagLayout());

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=0; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	l=new Label("Highlight:");
	gbl.setConstraints(l,gbc);
	p5.add(l);

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=1; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	highlight=new Choice();
	gbl.setConstraints(highlight,gbc);
	
	highlight.addItem("Neurons");
	highlight.addItem("Cell Descendents");
	highlight.addItem("A Cell Group");
	highlight.addItem("An Expression Type");
	highlight.addItem("A Cell Fate");
	highlight.addItem("Don't Highlight");
	highlight.select("Don't Highlight");
	p5.add(highlight);
	
	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=2; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	display_others = new Checkbox("Display Others");
	display_others.setState(true);
	gbl.setConstraints(display_others,gbc);
	p5.add(display_others);

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=3; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
	gbc.weightx=1.0; gbc.weighty=0.0;
	display_label = new Checkbox("Show Labels");
	gbl.setConstraints(display_label,gbc);
	p5.add(display_label);

 	gbc = new GridBagConstraints();
        gbc.gridx=0; gbc.gridy=4; gbc.gridwidth=1; gbc.gridheight=1;
        gbc.fill=gbc.NONE; gbc.anchor=gbc.NORTHWEST;
        gbc.weightx=1.0; gbc.weighty=0.0;
        display_zcells = new Checkbox("Show Z2, Z3");
	display_zcells.setState(true);
        gbl.setConstraints(display_zcells,gbc);
        p5.add(display_zcells);
	
	// A flexible panel goes here
	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=5; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.VERTICAL; gbc.anchor=gbc.CENTER;
	gbc.weightx=1.0; gbc.weighty=1.0;
	Panel pp=new Panel();
	gbl.setConstraints(pp,gbc);
	p5.add(pp);

	gbc = new GridBagConstraints();
	gbc.gridx=0; gbc.gridy=6; gbc.gridwidth=1; gbc.gridheight=1;
	gbc.fill=gbc.HORIZONTAL; gbc.anchor=gbc.SOUTH;
	gbc.weightx=1.0; gbc.weighty=0.0;
	doit=new Button("Set");
	gbl.setConstraints(doit,gbc);
	p5.add(doit);
	
	// PUT IT ALL TOGETHER
	setLayout(new BorderLayout());
	add("Center",p4);
	add("East",p5);

	delegate=_delegate;
	pack();
	resize(600,300);
	}

    public void dialogResult(DialogBox sender,int result) { }

    public boolean handleEvent(Event evt)
	{
	if (evt.target==doit && evt.id==Event.ACTION_EVENT)
	    {
	    int hlt=highlight.getSelectedIndex();
	    String result=null;
	    if (hlt==HIGHLIGHT_DESCENDENTS) 
		{
		result=cells.getSelectedItem();
		if (result==null) 
		    { (new DialogBox(this,this,"Nothing Selected",
				     "You need to select from the Cells list","Oops")).showDialog();
		      return true; }
		}
	    else if (hlt==HIGHLIGHT_GROUPS) 
		{
		result=groups.getSelectedItem();
		if (result==null) 
		    { (new DialogBox(this,this,"Nothing Selected",
				     "You need to select from the Groups list","Oops")).showDialog();
		      return true; }
		}
	    else if (hlt==HIGHLIGHT_PATTERNS) 
		{
		result=patterns.getSelectedItem();
		if (result==null) 
		    { (new DialogBox(this,this,"Nothing Selected",
				     "You need to select from the Patterns list","Oops")).showDialog();
		      return true; }
		}
	    else if (hlt==HIGHLIGHT_FATES) 
		{
		result=fates.getSelectedItem();
		if (result==null) 
		    { (new DialogBox(this,this,"Nothing Selected",
				     "You need to select from the Fates list","Oops")).showDialog();
		      return true; }
		}
	    delegate.setDisplayInfo(result,hlt,display_others.getState(),display_label.getState(),display_zcells.getState());
	    return true;
	    }
	else if (evt.id==Event.WINDOW_DESTROY)
	    {
	    hide();		// DON'T destroy; it's expensive to recreate me!
	    return true;
	    }
	else return super.handleEvent(evt);
	}

    }
