package neurodata;

import awwwesome.visualworld.ViewTransformer;
import java.awt.Graphics;
import awwwesome.visualworld.Line3D;
import java.awt.Color;

/** SynapseLine draws a line between two CellPoints in a Canvas3D.  The line represents
 a particular Synapse, and its colors are based on the synapse type.*/

public class SynapseLine extends Line3D
    {
    public Synapse synapse;

    public SynapseLine(Synapse s)
	{
	super("",s.from.cp,s.to.cp);
	if (s.type==Synapse.type_chemical)
	    {
	    color=Colors.synapseOutColor;
	    othercolor= Colors.synapseInColor;
	    }
	else
	    {
	    color = Colors.gapJunctionColor;
	    othercolor = Colors.gapJunctionColor;
	    }
	synapse=s;
	}
    
    public void project(Graphics g, ViewTransformer viewTransformer) 
	{
	/* override to only project if my synapse contains cellPoints that
	   are also projecting */
	
	if (synapse.to.cp.display_when_possible && synapse.from.cp.display_when_possible)
	    super.project(g,viewTransformer);
	}

    }
