/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Prototype;
import ec.util.Parameter;
import ec.util.RandomChoice;
import ec.util.RandomChoiceChooser;

public abstract class BreedingSource
implements Prototype,
RandomChoiceChooser {
    public static final String P_PROB = "prob";
    public static final float NO_PROBABILITY = -1.0f;
    public static final int UNUSED = -1;
    public static final int CHECKBOUNDARY = 8;
    public static final int DEFAULT_PRODUCED = 1;
    public float probability;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        Parameter parameter2 = this.defaultBase();
        if (!evolutionState.parameters.exists(parameter.push(P_PROB), parameter2.push(P_PROB))) {
            this.probability = -1.0f;
        } else {
            this.probability = evolutionState.parameters.getFloat(parameter.push(P_PROB), parameter2.push(P_PROB), 0.0);
            if ((double)this.probability < 0.0) {
                evolutionState.output.error("Breeding Source's probability must be a floating point value >= 0.0, or empty, which represents NO_PROBABILITY.", parameter.push(P_PROB), parameter2.push(P_PROB));
            }
        }
    }

    public final float getProbability(Object object) {
        return ((BreedingSource)object).probability;
    }

    public final void setProbability(Object object, float f) {
        ((BreedingSource)object).probability = f;
    }

    public static int pickRandom(BreedingSource[] breedingSourceArray, float f) {
        return RandomChoice.pickFromDistribution((Object[])breedingSourceArray, breedingSourceArray[0], f, 8);
    }

    public static void setupProbabilities(BreedingSource[] breedingSourceArray) {
        RandomChoice.organizeDistribution((Object[])breedingSourceArray, breedingSourceArray[0], true);
    }

    public abstract int typicalIndsProduced();

    public abstract boolean produces(EvolutionState var1, Population var2, int var3, int var4);

    public abstract void prepareToProduce(EvolutionState var1, int var2, int var3);

    public abstract void finishProducing(EvolutionState var1, int var2, int var3);

    public abstract int produce(int var1, int var2, int var3, int var4, Individual[] var5, EvolutionState var6, int var7);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract void preparePipeline(Object var1);
}

