/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.Breeder;
import ec.Evaluator;
import ec.Exchanger;
import ec.Finisher;
import ec.Initializer;
import ec.Population;
import ec.Singleton;
import ec.Statistics;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import java.io.IOException;

public class EvolutionState
implements Singleton {
    public ParameterDatabase parameters;
    public MersenneTwisterFast[] random;
    public Output output;
    public int breedthreads;
    public int evalthreads;
    public boolean checkpoint;
    public String checkpointPrefix;
    public int checkpointModulo;
    public int randomSeedOffset;
    public int[] seeds;
    public boolean quitOnRunComplete;
    public Object[] job;
    public String[] runtimeArguments;
    public int generation;
    public int numGenerations;
    public Population population;
    public Initializer initializer;
    public Finisher finisher;
    public Breeder breeder;
    public Evaluator evaluator;
    public Statistics statistics;
    public Exchanger exchanger;
    public static final int C_STARTED_FRESH = 0;
    public static final int C_STARTED_FROM_CHECKPOINT = 1;
    public static final int R_SUCCESS = 0;
    public static final int R_FAILURE = 1;
    public static final int R_NOTDONE = 2;
    public static final String P_INITIALIZER = "init";
    public static final String P_FINISHER = "finish";
    public static final String P_BREEDER = "breed";
    public static final String P_EVALUATOR = "eval";
    public static final String P_STATISTICS = "stat";
    public static final String P_EXCHANGER = "exch";
    public static final String P_GENERATIONS = "generations";
    public static final String P_QUITONRUNCOMPLETE = "quit-on-run-complete";
    public static final String P_CHECKPOINTPREFIX = "prefix";
    public static final String P_CHECKPOINTMODULO = "checkpoint-modulo";
    public static final String P_CHECKPOINT = "checkpoint";

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        Parameter parameter2 = new Parameter(P_CHECKPOINT);
        this.checkpoint = this.parameters.getBoolean(parameter2, null, false);
        parameter2 = new Parameter(P_CHECKPOINTPREFIX);
        this.checkpointPrefix = this.parameters.getString(parameter2, null);
        if (this.checkpointPrefix == null) {
            this.output.fatal("No checkpoint prefix specified.", parameter2);
        }
        parameter2 = new Parameter(P_CHECKPOINTMODULO);
        this.checkpointModulo = this.parameters.getInt(parameter2, null, 1);
        if (this.checkpointModulo == 0) {
            this.output.fatal("The checkpoint modulo must be an integer >0.", parameter2);
        }
        parameter2 = new Parameter(P_GENERATIONS);
        this.numGenerations = this.parameters.getInt(parameter2, null, 1);
        if (this.numGenerations == 0) {
            this.output.fatal("The number of generations must be an integer >0.", parameter2);
        }
        parameter2 = new Parameter(P_QUITONRUNCOMPLETE);
        this.quitOnRunComplete = this.parameters.getBoolean(parameter2, null, false);
        parameter2 = new Parameter(P_INITIALIZER);
        this.initializer = (Initializer)this.parameters.getInstanceForParameter(parameter2, null, Initializer.class);
        this.initializer.setup(this, parameter2);
        parameter2 = new Parameter(P_FINISHER);
        this.finisher = (Finisher)this.parameters.getInstanceForParameter(parameter2, null, Finisher.class);
        this.finisher.setup(this, parameter2);
        parameter2 = new Parameter(P_BREEDER);
        this.breeder = (Breeder)this.parameters.getInstanceForParameter(parameter2, null, Breeder.class);
        this.breeder.setup(this, parameter2);
        parameter2 = new Parameter(P_EVALUATOR);
        this.evaluator = (Evaluator)this.parameters.getInstanceForParameter(parameter2, null, Evaluator.class);
        this.evaluator.setup(this, parameter2);
        parameter2 = new Parameter(P_STATISTICS);
        this.statistics = (Statistics)this.parameters.getInstanceForParameterEq(parameter2, null, Statistics.class);
        this.statistics.setup(this, parameter2);
        parameter2 = new Parameter(P_EXCHANGER);
        this.exchanger = (Exchanger)this.parameters.getInstanceForParameter(parameter2, null, Exchanger.class);
        this.exchanger.setup(this, parameter2);
        this.generation = 0;
    }

    public void resetFromCheckpoint() throws IOException {
        this.output.restart();
        this.exchanger.reinitializeContacts(this);
        this.evaluator.reinitializeContacts(this);
    }

    public void finish(int n) {
    }

    public void startFromCheckpoint() {
    }

    public void startFresh() {
    }

    public int evolve() throws InternalError {
        return 2;
    }

    public void run(int n) {
        if (n == 0) {
            this.startFresh();
        } else {
            this.startFromCheckpoint();
        }
        int n2 = 2;
        while (n2 == 2) {
            n2 = this.evolve();
        }
        this.finish(n2);
    }
}

