/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.util.Checkpoint;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import ec.util.Version;
import java.io.File;
import java.io.PrintWriter;

public class Evolve {
    public static final String P_PRINTACCESSEDPARAMETERS = "print-accessed-params";
    public static final String P_PRINTUSEDPARAMETERS = "print-used-params";
    public static final String P_PRINTALLPARAMETERS = "print-all-params";
    public static final String P_PRINTUNUSEDPARAMETERS = "print-unused-params";
    public static final String P_PRINTUNACCESSEDPARAMETERS = "print-unaccessed-params";
    public static final String A_CHECKPOINT = "-checkpoint";
    public static final String A_FILE = "-file";
    public static final String P_VERBOSITY = "verbosity";
    public static final String P_EVALTHREADS = "evalthreads";
    public static final String P_BREEDTHREADS = "breedthreads";
    public static final String P_SEED = "seed";
    public static final String V_SEED_TIME = "time";
    public static final String P_STATE = "state";
    public static final String V_THREADS_AUTO = "auto";

    public static EvolutionState possiblyRestoreFromCheckpoint(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equals(A_CHECKPOINT)) {
                System.err.println("Restoring from Checkpoint " + stringArray[n + 1]);
                try {
                    return Checkpoint.restoreFromCheckpoint(stringArray[n + 1]);
                }
                catch (Exception exception) {
                    Output.initialError("An exception was generated upon starting up from a checkpoint.\nHere it is:\n" + exception);
                }
            }
            ++n;
        }
        return null;
    }

    public static ParameterDatabase loadParameterDatabase(String[] stringArray) {
        ParameterDatabase parameterDatabase = null;
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equals(A_FILE)) {
                try {
                    parameterDatabase = new ParameterDatabase(new File(new File(stringArray[n + 1]).getAbsolutePath()), stringArray);
                    break;
                }
                catch (Exception exception) {
                    Output.initialError("An exception was generated upon reading the parameter file \"" + stringArray[n + 1] + "\".\nHere it is:\n" + exception);
                }
            }
            ++n;
        }
        if (parameterDatabase == null) {
            Output.initialError("No parameter file was specified.");
        }
        return parameterDatabase;
    }

    public static int determineThreads(Output output, ParameterDatabase parameterDatabase, Parameter parameter) {
        int n;
        block7: {
            n = 1;
            String string = parameterDatabase.getString(parameter, null);
            if (string == null) {
                output.fatal("Threads number must exist.", parameter, null);
            } else {
                if (V_THREADS_AUTO.equalsIgnoreCase(string)) {
                    Runtime runtime = Runtime.getRuntime();
                    try {
                        return (Integer)runtime.getClass().getMethod("availableProcessors", null).invoke((Object)runtime, null);
                    }
                    catch (Exception exception) {
                        output.fatal("Whoa! This Java version is to old to have the Runtime.availableProcessors() method available.\nThis means you can't use 'auto' as a threads option.", parameter, null);
                        break block7;
                    }
                }
                try {
                    n = parameterDatabase.getInt(parameter, null);
                }
                catch (NumberFormatException numberFormatException) {
                    output.fatal("Invalid, non-integer threads value (" + n + ")", parameter, null);
                }
            }
        }
        return n;
    }

    public static int determineSeed(Output output, ParameterDatabase parameterDatabase, Parameter parameter, long l, int n, boolean bl) {
        int n2 = 1;
        String string = parameterDatabase.getString(parameter, null);
        if (string == null && !bl) {
            output.fatal("Seed must exist.", parameter, null);
        } else if (V_SEED_TIME.equalsIgnoreCase(string) || string == null && bl) {
            if (string == null && bl) {
                output.warnOnce("Using automatic determination number of threads, but not all seeds are defined.\nThe rest will be defined using the wall clock time.");
            }
            if ((n2 = (int)l) == 0) {
                output.fatal("Whoa! This Java version is returning 0 for System.currentTimeMillis(), which ain't right.  This means you can't use 'time' as a seed ", parameter, null);
            }
        } else {
            try {
                n2 = parameterDatabase.getInt(parameter, null);
            }
            catch (NumberFormatException numberFormatException) {
                output.fatal("Invalid, non-integer seed value (" + n2 + ")", parameter, null);
            }
        }
        return n2 + n;
    }

    public static EvolutionState initialize(ParameterDatabase parameterDatabase, int n) {
        EvolutionState evolutionState = null;
        int n2 = 1;
        int n3 = 1;
        int n4 = parameterDatabase.getInt(new Parameter(P_VERBOSITY), null, 0);
        if (n4 < 0) {
            Output.initialError("Verbosity should be an integer >= 0.\n", new Parameter(P_VERBOSITY));
        }
        Output output = new Output(true, n4);
        output.addLog(0, 0, false);
        output.addLog(1, 0, true);
        output.systemMessage(Version.message());
        n2 = Evolve.determineThreads(output, parameterDatabase, new Parameter(P_BREEDTHREADS));
        n3 = Evolve.determineThreads(output, parameterDatabase, new Parameter(P_EVALTHREADS));
        boolean bl = V_THREADS_AUTO.equalsIgnoreCase(parameterDatabase.getString(new Parameter(P_BREEDTHREADS), null)) || V_THREADS_AUTO.equalsIgnoreCase(parameterDatabase.getString(new Parameter(P_EVALTHREADS), null));
        MersenneTwisterFast[] mersenneTwisterFastArray = new MersenneTwisterFast[n2 > n3 ? n2 : n3];
        int[] nArray = new int[mersenneTwisterFastArray.length];
        String string = "Seed: ";
        int n5 = (int)System.currentTimeMillis();
        int n6 = 0;
        while (n6 < mersenneTwisterFastArray.length) {
            nArray[n6] = Evolve.determineSeed(output, parameterDatabase, new Parameter(P_SEED).push("" + n6), n5 + n6, mersenneTwisterFastArray.length * n, bl);
            int n7 = 0;
            while (n7 < n6) {
                if (nArray[n6] == nArray[n7]) {
                    output.fatal("seed." + n6 + " (" + nArray[n6] + ") and " + P_SEED + "." + n7 + " (" + nArray[n7] + ") ought not be the same seed.", null, null);
                }
                ++n7;
            }
            mersenneTwisterFastArray[n6] = new MersenneTwisterFast(nArray[n6]);
            string = String.valueOf(string) + nArray[n6] + " ";
            ++n6;
        }
        evolutionState = (EvolutionState)parameterDatabase.getInstanceForParameter(new Parameter(P_STATE), null, EvolutionState.class);
        evolutionState.parameters = parameterDatabase;
        evolutionState.random = mersenneTwisterFastArray;
        evolutionState.output = output;
        evolutionState.evalthreads = n3;
        evolutionState.breedthreads = n2;
        evolutionState.randomSeedOffset = n;
        evolutionState.seeds = nArray;
        output.systemMessage("Threads:  breed/" + n2 + " eval/" + n3);
        output.systemMessage(string);
        return evolutionState;
    }

    public static void cleanup(EvolutionState evolutionState) {
        evolutionState.output.flush();
        PrintWriter printWriter = new PrintWriter(System.err);
        evolutionState.parameters.getBoolean(new Parameter(P_PRINTUSEDPARAMETERS), null, false);
        evolutionState.parameters.getBoolean(new Parameter(P_PRINTACCESSEDPARAMETERS), null, false);
        evolutionState.parameters.getBoolean(new Parameter(P_PRINTUNUSEDPARAMETERS), null, false);
        evolutionState.parameters.getBoolean(new Parameter(P_PRINTUNACCESSEDPARAMETERS), null, false);
        evolutionState.parameters.getBoolean(new Parameter(P_PRINTALLPARAMETERS), null, false);
        if (evolutionState.parameters.getBoolean(new Parameter(P_PRINTUSEDPARAMETERS), null, false)) {
            printWriter.println("\n\nUsed Parameters\n===============\n");
            evolutionState.parameters.listGotten(printWriter);
        }
        if (evolutionState.parameters.getBoolean(new Parameter(P_PRINTACCESSEDPARAMETERS), null, false)) {
            printWriter.println("\n\nAccessed Parameters\n===================\n");
            evolutionState.parameters.listAccessed(printWriter);
        }
        if (evolutionState.parameters.getBoolean(new Parameter(P_PRINTUNUSEDPARAMETERS), null, false)) {
            printWriter.println("\n\nUnused Parameters\n================= (Ignore parent.x references) \n");
            evolutionState.parameters.listNotGotten(printWriter);
        }
        if (evolutionState.parameters.getBoolean(new Parameter(P_PRINTUNACCESSEDPARAMETERS), null, false)) {
            printWriter.println("\n\nUnaccessed Parameters\n===================== (Ignore parent.x references) \n");
            evolutionState.parameters.listNotAccessed(printWriter);
        }
        if (evolutionState.parameters.getBoolean(new Parameter(P_PRINTALLPARAMETERS), null, false)) {
            printWriter.println("\n\nAll Parameters\n==============\n");
            evolutionState.parameters.list(printWriter, false);
        }
        printWriter.flush();
        System.err.flush();
        System.out.flush();
        evolutionState.output.close();
    }

    public static void main(String[] stringArray) {
        ParameterDatabase parameterDatabase;
        int n;
        int n2 = 0;
        EvolutionState evolutionState = Evolve.possiblyRestoreFromCheckpoint(stringArray);
        if (evolutionState != null) {
            try {
                if (evolutionState.runtimeArguments == null) {
                    Output.initialError("Checkpoint completed from job started by foreign program (probably GUI).  Exiting...");
                }
                stringArray = evolutionState.runtimeArguments;
                n2 = (Integer)evolutionState.job[0] + 1;
            }
            catch (Exception exception) {
                Output.initialError("EvolutionState's jobs variable is not set up properly.  Exiting...");
            }
            evolutionState.run(1);
            Evolve.cleanup(evolutionState);
        }
        if ((n = (parameterDatabase = Evolve.loadParameterDatabase(stringArray)).getIntWithDefault(new Parameter("jobs"), null, 1)) < 1) {
            Output.initialError("The 'jobs' parameter must be >= 1 (or not exist, which defaults to 1)");
        }
        int n3 = n2;
        while (n3 < n) {
            if (parameterDatabase == null) {
                parameterDatabase = Evolve.loadParameterDatabase(stringArray);
            }
            evolutionState = Evolve.initialize(parameterDatabase, n3);
            evolutionState.output.systemMessage("Job: " + n3);
            evolutionState.job = new Object[1];
            evolutionState.job[0] = new Integer(n3);
            evolutionState.runtimeArguments = stringArray;
            if (n > 1) {
                String string = "job." + n3 + ".";
                evolutionState.output.setFilePrefix(string);
                evolutionState.checkpointPrefix = String.valueOf(string) + evolutionState.checkpointPrefix;
            }
            evolutionState.run(0);
            Evolve.cleanup(evolutionState);
            parameterDatabase = null;
            ++n3;
        }
        System.exit(0);
    }
}

