/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Fitness;
import ec.Prototype;
import ec.Species;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public abstract class Individual
implements Prototype {
    public static final String P_INDIVIDUAL = "individual";
    public static final String EVALUATED_PREAMBLE = "Evaluated: ";
    public Fitness fitness;
    public Species species;
    public boolean evaluated;

    public Object clone() {
        try {
            Individual individual = (Individual)super.clone();
            if (individual.fitness != null) {
                individual.fitness = (Fitness)this.fitness.clone();
            }
            return individual;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public long size() {
        return 0L;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "{" + this.hashCode() + "}";
    }

    public String genotypeToStringForHumans() {
        return this.toString();
    }

    public String genotypeToString() {
        return this.toString();
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
    }

    public void printIndividualForHumans(EvolutionState evolutionState, int n, int n2) {
        evolutionState.output.println(EVALUATED_PREAMBLE + Code.encode(this.evaluated), n2, n);
        this.fitness.printFitnessForHumans(evolutionState, n, n2);
        evolutionState.output.println(this.genotypeToStringForHumans(), n2, n);
    }

    public void printIndividual(EvolutionState evolutionState, int n, int n2) {
        evolutionState.output.println(EVALUATED_PREAMBLE + Code.encode(this.evaluated), n2, n);
        this.fitness.printFitness(evolutionState, n, n2);
        evolutionState.output.println(this.genotypeToString(), n2, n);
    }

    public void printIndividual(EvolutionState evolutionState, PrintWriter printWriter) {
        printWriter.println(EVALUATED_PREAMBLE + Code.encode(this.evaluated));
        this.fitness.printFitness(evolutionState, printWriter);
        printWriter.println(this.genotypeToString());
    }

    public void readIndividual(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        this.evaluated = Code.readBooleanWithPreamble(EVALUATED_PREAMBLE, evolutionState, lineNumberReader);
        this.fitness.readFitness(evolutionState, lineNumberReader);
        this.parseGenotype(evolutionState, lineNumberReader);
    }

    protected void parseGenotype(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        evolutionState.output.fatal("parseGenotype(EvolutionState, LineNumberReader) not implemented in " + this.getClass());
    }

    public void writeIndividual(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.evaluated);
        this.fitness.writeFitness(evolutionState, dataOutput);
        this.writeGenotype(evolutionState, dataOutput);
    }

    public void writeGenotype(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        evolutionState.output.fatal("writeGenotype(EvolutionState, DataOutput) not implemented in " + this.getClass());
    }

    public void readGenotype(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        evolutionState.output.fatal("readGenotype(EvolutionState, DataOutput) not implemented in " + this.getClass());
    }

    public void readIndividual(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        this.evaluated = dataInput.readBoolean();
        this.fitness.readFitness(evolutionState, dataInput);
        this.readGenotype(evolutionState, dataInput);
    }
}

