/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Group;
import ec.Subpopulation;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class Population
implements Group {
    public Subpopulation[] subpops;
    public static final String P_SIZE = "subpops";
    public static final String P_SUBPOP = "subpop";
    public static final String P_DEFAULT_SUBPOP = "default-subpop";
    public static final String NUM_SUBPOPS_PREAMBLE = "Number of Subpopulations: ";
    public static final String SUBPOP_INDEX_PREAMBLE = "Subpopulation Number: ";

    public Group emptyClone() {
        try {
            Population population = (Population)this.clone();
            population.subpops = new Subpopulation[this.subpops.length];
            int n = 0;
            while (n < this.subpops.length) {
                population.subpops[n] = (Subpopulation)this.subpops[n].emptyClone();
                ++n;
            }
            return population;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        Parameter parameter2 = parameter.push(P_SIZE);
        int n = evolutionState.parameters.getInt(parameter2, null, 1);
        if (n == 0) {
            evolutionState.output.fatal("Population size must be >0.\n", parameter.push(P_SIZE));
        }
        this.subpops = new Subpopulation[n];
        int n2 = 0;
        while (n2 < n) {
            parameter2 = parameter.push(P_SUBPOP).push("" + n2);
            if (!evolutionState.parameters.exists(parameter2, null) && evolutionState.parameters.exists(parameter2 = parameter.push(P_DEFAULT_SUBPOP), null)) {
                evolutionState.output.warning("Class for subpopulation " + n2 + " not specified, using provided default: " + evolutionState.parameters.getString(parameter2, null));
            }
            this.subpops[n2] = (Subpopulation)evolutionState.parameters.getInstanceForParameterEq(parameter2, null, Subpopulation.class);
            this.subpops[n2].setup(evolutionState, parameter2);
            ++n2;
        }
    }

    public void populate(EvolutionState evolutionState, int n) {
        int n2 = 0;
        while (n2 < this.subpops.length) {
            this.subpops[n2].populate(evolutionState, n);
            ++n2;
        }
    }

    public void printPopulationForHumans(EvolutionState evolutionState, int n, int n2) {
        evolutionState.output.println(NUM_SUBPOPS_PREAMBLE + this.subpops.length, n2, n);
        int n3 = 0;
        while (n3 < this.subpops.length) {
            evolutionState.output.println(SUBPOP_INDEX_PREAMBLE + n3, n2, n);
            this.subpops[n3].printSubpopulationForHumans(evolutionState, n, n2);
            ++n3;
        }
    }

    public void printPopulation(EvolutionState evolutionState, int n, int n2) {
        evolutionState.output.println(NUM_SUBPOPS_PREAMBLE + Code.encode(this.subpops.length), n2, n);
        int n3 = 0;
        while (n3 < this.subpops.length) {
            evolutionState.output.println(SUBPOP_INDEX_PREAMBLE + Code.encode(n3), n2, n);
            this.subpops[n3].printSubpopulation(evolutionState, n, n2);
            ++n3;
        }
    }

    public void printPopulation(EvolutionState evolutionState, PrintWriter printWriter) {
        printWriter.println(NUM_SUBPOPS_PREAMBLE + Code.encode(this.subpops.length));
        int n = 0;
        while (n < this.subpops.length) {
            printWriter.println(SUBPOP_INDEX_PREAMBLE + Code.encode(n));
            this.subpops[n].printSubpopulation(evolutionState, printWriter);
            ++n;
        }
    }

    public void readPopulation(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        int n = Code.readIntegerWithPreamble(NUM_SUBPOPS_PREAMBLE, evolutionState, lineNumberReader);
        if (n != this.subpops.length) {
            evolutionState.output.fatal("On reading population from text stream, the number of subpopulations was wrong.");
        }
        int n2 = 0;
        while (n2 < this.subpops.length) {
            int n3 = Code.readIntegerWithPreamble(SUBPOP_INDEX_PREAMBLE, evolutionState, lineNumberReader);
            if (n3 != n2) {
                evolutionState.output.warnOnce("On reading population from text stream, some subpopulation indexes in the population did not match.");
            }
            this.subpops[n2].readSubpopulation(evolutionState, lineNumberReader);
            ++n2;
        }
    }

    public void writePopulation(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.subpops.length);
        int n = 0;
        while (n < this.subpops.length) {
            this.subpops[n].writeSubpopulation(evolutionState, dataOutput);
            ++n;
        }
    }

    public void readPopulation(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != this.subpops.length) {
            evolutionState.output.fatal("On reading subpopulation from binary stream, the number of subpopulations was wrong.");
        }
        int n2 = 0;
        while (n2 < this.subpops.length) {
            this.subpops[n2].readSubpopulation(evolutionState, dataInput);
            ++n2;
        }
    }
}

