/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Group;
import ec.Individual;
import ec.Species;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Subpopulation
implements Group {
    public File loadInds;
    public Species species;
    public Individual[] individuals;
    public int numDuplicateRetries;
    public static final String P_SUBPOPULATION = "subpop";
    public static final String P_FILE = "file";
    public static final String P_SUBPOPSIZE = "size";
    public static final String P_SPECIES = "species";
    public static final String P_RETRIES = "duplicate-retries";
    public static final String NUM_INDIVIDUALS_PREAMBLE = "Number of Individuals: ";
    public static final String INDIVIDUAL_INDEX_PREAMBLE = "Individual Number: ";

    public Parameter defaultBase() {
        return ECDefaults.base().push(P_SUBPOPULATION);
    }

    public Group emptyClone() {
        try {
            Subpopulation subpopulation = (Subpopulation)this.clone();
            subpopulation.species = this.species;
            subpopulation.individuals = new Individual[this.individuals.length];
            return subpopulation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        Parameter parameter2 = this.defaultBase();
        this.loadInds = evolutionState.parameters.getFile(parameter.push(P_FILE), null);
        this.species = (Species)evolutionState.parameters.getInstanceForParameter(parameter.push(P_SPECIES), parameter2.push(P_SPECIES), Species.class);
        this.species.setup(evolutionState, parameter.push(P_SPECIES));
        int n = evolutionState.parameters.getInt(parameter.push(P_SUBPOPSIZE), parameter2.push(P_SUBPOPSIZE), 1);
        if (n <= 0) {
            evolutionState.output.fatal("Subpopulation size must be an integer >= 1.\n", parameter.push(P_SUBPOPSIZE), parameter2.push(P_SUBPOPSIZE));
        }
        this.numDuplicateRetries = evolutionState.parameters.getInt(parameter.push(P_RETRIES), parameter2.push(P_RETRIES), 0);
        if (this.numDuplicateRetries < 0) {
            evolutionState.output.fatal("The number of retries for duplicates must be an integer >= 0.\n", parameter.push(P_RETRIES), parameter2.push(P_RETRIES));
        }
        this.individuals = new Individual[n];
    }

    public void populate(EvolutionState evolutionState, int n) {
        if (this.loadInds != null) {
            try {
                this.readSubpopulation(evolutionState, new LineNumberReader(new FileReader(this.loadInds)));
            }
            catch (IOException iOException) {
                evolutionState.output.fatal("An IOException occurred when trying to read from the file " + this.loadInds + ".  The IOException was: \n" + iOException);
            }
        } else {
            Hashtable<Individual, Individual> hashtable = null;
            if (this.numDuplicateRetries >= 1) {
                hashtable = new Hashtable<Individual, Individual>(this.individuals.length / 2);
            }
            int n2 = 0;
            while (n2 < this.individuals.length) {
                int n3 = 0;
                while (n3 <= this.numDuplicateRetries) {
                    Object v;
                    this.individuals[n2] = this.species.newIndividual(evolutionState, n);
                    if (this.numDuplicateRetries >= 1 && (v = hashtable.get(this.individuals[n2])) == null) {
                        hashtable.put(this.individuals[n2], this.individuals[n2]);
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public void printSubpopulationForHumans(EvolutionState evolutionState, int n, int n2) {
        evolutionState.output.println(NUM_INDIVIDUALS_PREAMBLE + this.individuals.length, n2, n);
        int n3 = 0;
        while (n3 < this.individuals.length) {
            evolutionState.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(n3), n2, n);
            this.individuals[n3].printIndividualForHumans(evolutionState, n, n2);
            ++n3;
        }
    }

    public void printSubpopulation(EvolutionState evolutionState, int n, int n2) {
        evolutionState.output.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.length), n2, n);
        int n3 = 0;
        while (n3 < this.individuals.length) {
            evolutionState.output.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(n3), n2, n);
            this.individuals[n3].printIndividual(evolutionState, n, n2);
            ++n3;
        }
    }

    public void printSubpopulation(EvolutionState evolutionState, PrintWriter printWriter) {
        printWriter.println(NUM_INDIVIDUALS_PREAMBLE + Code.encode(this.individuals.length));
        int n = 0;
        while (n < this.individuals.length) {
            printWriter.println(INDIVIDUAL_INDEX_PREAMBLE + Code.encode(n));
            this.individuals[n].printIndividual(evolutionState, printWriter);
            ++n;
        }
    }

    public void readSubpopulation(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        int n = Code.readIntegerWithPreamble(NUM_INDIVIDUALS_PREAMBLE, evolutionState, lineNumberReader);
        if (n != this.individuals.length) {
            evolutionState.output.warnOnce("On reading subpopulation from text stream, the subpopulation size didn't match.\nHad to resize and use newIndividual() instead of readIndividual().");
            this.individuals = new Individual[n];
            int n2 = 0;
            while (n2 < this.individuals.length) {
                int n3 = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, evolutionState, lineNumberReader);
                if (n3 != n2) {
                    evolutionState.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.");
                }
                this.individuals[n2] = this.species.newIndividual(evolutionState, lineNumberReader);
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < this.individuals.length) {
                int n5 = Code.readIntegerWithPreamble(INDIVIDUAL_INDEX_PREAMBLE, evolutionState, lineNumberReader);
                if (n5 != n4) {
                    evolutionState.output.warnOnce("On reading subpopulation from text stream, some individual indexes in the subpopulation did not match.");
                }
                if (this.individuals[n4] != null) {
                    this.individuals[n4].readIndividual(evolutionState, lineNumberReader);
                } else {
                    evolutionState.output.warnOnce("On reading subpopulation from text stream, some of the preexisting subpopulation's slots were null.\nHad to use newIndividual() instead of readIndividual().");
                    this.individuals[n4] = this.species.newIndividual(evolutionState, lineNumberReader);
                }
                ++n4;
            }
        }
    }

    public void writeSubpopulation(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.individuals.length);
        int n = 0;
        while (n < this.individuals.length) {
            this.individuals[n].writeIndividual(evolutionState, dataOutput);
            ++n;
        }
    }

    public void readSubpopulation(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != this.individuals.length) {
            evolutionState.output.warnOnce("On reading subpopulation from binary stream, the subpopulation size was incorrect.\nHad to resize and use newIndividual() instead of readIndividual().");
            this.individuals = new Individual[n];
            int n2 = 0;
            while (n2 < this.individuals.length) {
                this.individuals[n2] = this.species.newIndividual(evolutionState, dataInput);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.individuals.length) {
                this.individuals[n3].readIndividual(evolutionState, dataInput);
                ++n3;
            }
        }
    }
}

