/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class BufferedBreedingPipeline
extends BreedingPipeline {
    public static final String P_BUFSIZE = "num-inds";
    public static final String P_BUFFERED = "buffered";
    public static final int INDS_PRODUCED = 1;
    public static final int NUM_SOURCES = 1;
    public Individual[] buffer;
    public int currentSize;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_BUFFERED);
    }

    public int numSources() {
        return 1;
    }

    public int typicalIndsProduced() {
        return 1;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        int n = evolutionState.parameters.getInt(parameter.push(P_BUFSIZE), parameter2.push(P_BUFSIZE), 1);
        if (n == 0) {
            evolutionState.output.fatal("BufferedBreedingPipeline's number of individuals must be >= 1.", parameter.push(P_BUFSIZE), parameter2.push(P_BUFSIZE));
        }
        this.buffer = new Individual[n];
        this.currentSize = 0;
    }

    public void prepareToProduce(EvolutionState evolutionState, int n, int n2) {
        super.prepareToProduce(evolutionState, n, n2);
        this.currentSize = 0;
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6 = n3;
        while (n6 < n + n3) {
            if (this.currentSize == 0) {
                this.sources[0].produce(this.buffer.length, this.buffer.length, 0, n4, this.buffer, evolutionState, n5);
                this.currentSize = this.buffer.length;
                if (this.sources[0] instanceof SelectionMethod) {
                    int n7 = 0;
                    while (n7 < this.buffer.length) {
                        this.buffer[n7] = (Individual)this.buffer[n7].clone();
                        ++n7;
                    }
                }
            }
            individualArray[n6] = this.buffer[this.currentSize - 1];
            --this.currentSize;
            ++n6;
        }
        return n;
    }
}

