/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class GenerationSwitchPipeline
extends BreedingPipeline {
    public static final String P_SWITCHAT = "switch-at";
    public static final String P_MULTIBREED = "generation-switch";
    public static final String P_GEN_MAX = "generate-max";
    public static final int NUM_SOURCES = 2;
    public int maxGeneratable;
    public boolean generateMax;
    public int generationSwitch;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_MULTIBREED);
    }

    public int numSources() {
        return 2;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        evolutionState.output.exitIfErrors();
        this.generationSwitch = evolutionState.parameters.getInt(parameter.push(P_SWITCHAT), parameter2.push(P_SWITCHAT), 0);
        if (this.generationSwitch < 0) {
            evolutionState.output.fatal("GenerationSwitchPipeline must have a switch-at >= 0", parameter.push(P_SWITCHAT), parameter2.push(P_SWITCHAT));
        }
        this.generateMax = evolutionState.parameters.getBoolean(parameter.push(P_GEN_MAX), parameter2.push(P_GEN_MAX), true);
        this.maxGeneratable = 0;
    }

    public int typicalIndsProduced() {
        if (this.maxGeneratable == 0) {
            this.maxGeneratable = this.maxChildProduction();
        }
        return this.maxGeneratable;
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6;
        int n7;
        BreedingSource breedingSource;
        BreedingSource breedingSource2 = breedingSource = evolutionState.generation < this.generationSwitch ? this.sources[0] : this.sources[1];
        if (this.generateMax) {
            if (this.maxGeneratable == 0) {
                this.maxGeneratable = this.maxChildProduction();
            }
            if ((n7 = this.maxGeneratable) < n) {
                n7 = n;
            }
            if (n7 > n2) {
                n7 = n2;
            }
            n6 = breedingSource.produce(n7, n7, n3, n4, individualArray, evolutionState, n5);
        } else {
            n6 = breedingSource.produce(n, n2, n3, n4, individualArray, evolutionState, n5);
        }
        if (breedingSource instanceof SelectionMethod) {
            n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        return n6;
    }
}

