/*
 * Decompiled with CFR 0.152.
 */
package ec.breed;

import ec.BreedingPipeline;
import ec.BreedingSource;
import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.breed.BreedDefaults;
import ec.util.Parameter;

public class MultiBreedingPipeline
extends BreedingPipeline {
    public static final String P_GEN_MAX = "generate-max";
    public static final String P_MULTIBREED = "multibreed";
    public int maxGeneratable;
    public boolean generateMax;

    public Parameter defaultBase() {
        return BreedDefaults.base().push(P_MULTIBREED);
    }

    public int numSources() {
        return 0;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        Parameter parameter2 = this.defaultBase();
        float f = 0.0f;
        int n = 0;
        while (n < this.sources.length) {
            if (!(this.sources[n] instanceof BreedingPipeline)) {
                evolutionState.output.error("Source #" + n + "is not a BreedingPipeline", parameter);
            } else if ((double)this.sources[n].probability < 0.0) {
                evolutionState.output.error("Pipe #" + n + " must have a probability >= 0.0", parameter);
            } else {
                f += this.sources[n].probability;
            }
            ++n;
        }
        evolutionState.output.exitIfErrors();
        if ((double)f == 0.0) {
            evolutionState.output.warning("MultiBreedingPipeline's children have all zero probabilities -- this will be treated as a uniform distribution.  This could be an error.", parameter);
        }
        BreedingSource.setupProbabilities(this.sources);
        this.generateMax = evolutionState.parameters.getBoolean(parameter.push(P_GEN_MAX), parameter2.push(P_GEN_MAX), true);
        this.maxGeneratable = 0;
    }

    public int typicalIndsProduced() {
        if (this.maxGeneratable == 0) {
            this.maxGeneratable = this.maxChildProduction();
        }
        return this.maxGeneratable;
    }

    public int produce(int n, int n2, int n3, int n4, Individual[] individualArray, EvolutionState evolutionState, int n5) {
        int n6;
        int n7;
        BreedingSource breedingSource = this.sources[BreedingSource.pickRandom(this.sources, evolutionState.random[n5].nextFloat())];
        if (this.generateMax) {
            if (this.maxGeneratable == 0) {
                this.maxGeneratable = this.maxChildProduction();
            }
            if ((n7 = this.maxGeneratable) < n) {
                n7 = n;
            }
            if (n7 > n2) {
                n7 = n2;
            }
            n6 = breedingSource.produce(n7, n7, n3, n4, individualArray, evolutionState, n5);
        } else {
            n6 = breedingSource.produce(n, n2, n3, n4, individualArray, evolutionState, n5);
        }
        if (breedingSource instanceof SelectionMethod) {
            n7 = n3;
            while (n7 < n6 + n3) {
                individualArray[n7] = (Individual)individualArray[n7].clone();
                ++n7;
            }
        }
        return n6;
    }
}

