/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Population;
import ec.gep.GEPSpecies;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import java.util.Hashtable;

public abstract class GEPBreedingPipeline
extends BreedingPipeline {
    private static Hashtable htReplacementArrays = null;

    public void setup(EvolutionState evolutionState, Parameter parameter) {
        super.setup(evolutionState, parameter);
        htReplacementArrays = null;
    }

    public boolean produces(EvolutionState evolutionState, Population population, int n, int n2) {
        if (!super.produces(evolutionState, population, n, n2)) {
            return false;
        }
        return population.subpops[n].species instanceof GEPSpecies;
    }

    public int[] chooseWithoutReplacement(EvolutionState evolutionState, int n, int n2, int n3) {
        IntegerArray integerArray;
        Integer n4 = n3;
        if (htReplacementArrays == null) {
            htReplacementArrays = new Hashtable();
        }
        if ((integerArray = (IntegerArray)htReplacementArrays.get(n4)) == null) {
            integerArray = new IntegerArray(n3);
            htReplacementArrays.put(n4, integerArray);
        }
        int[] nArray = integerArray.indicies;
        int[] nArray2 = new int[n2];
        MersenneTwisterFast mersenneTwisterFast = evolutionState.random[n];
        int n5 = n3;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = mersenneTwisterFast.nextInt(n5);
            nArray2[n6] = nArray[n7];
            nArray[n7] = nArray[--n5];
            nArray[n5] = nArray2[n6];
            ++n6;
        }
        return nArray2;
    }

    private static class IntegerArray {
        public int[] indicies = null;

        IntegerArray(int n) {
            this.indicies = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.indicies[n2] = n2;
                ++n2;
            }
        }
    }
}

