/*
 * Decompiled with CFR 0.152.
 */
package ec.gep;

import ec.EvolutionState;
import ec.gep.GEPConstantTerminalSymbol;
import ec.gep.GEPExpressionTreeNode;
import ec.gep.GEPFunctionSymbol;
import ec.gep.GEPIndividual;
import ec.gep.GEPSpecies;
import ec.gep.GEPSymbol;
import ec.gep.GEPSymbolSet;
import ec.gep.GEPTerminalSymbol;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.LinkedList;

public class GEPChromosome
implements Cloneable {
    public GEPIndividual myGEPIndividual = null;
    public GEPExpressionTreeNode[] parsedGeneExpressions = null;
    public int[][] genome;
    public double[][] genomeConstants;
    public int[][] genomeDc;

    public boolean equals(Object object) {
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        GEPChromosome gEPChromosome = (GEPChromosome)object;
        if (this.genome.length != gEPChromosome.genome.length) {
            return false;
        }
        int n = 0;
        while (n < this.genome.length) {
            int n2 = 0;
            while (n2 < this.genome[n].length) {
                if (this.genome[n][n2] != gEPChromosome.genome[n][n2]) {
                    return false;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.genomeDc[n].length) {
                if (this.genomeDc[n][n2] != gEPChromosome.genomeDc[n][n2]) {
                    return false;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.genomeConstants[n].length) {
                if (this.genomeConstants[n][n2] != gEPChromosome.genomeConstants[n][n2]) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        n = n << 1 | n >>> 31;
        int n2 = 0;
        while (n2 < this.genome.length) {
            int n3 = 0;
            while (n3 < this.genome[n2].length) {
                n = (n << 1 | n >>> 31) ^ this.genome[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public void setup(EvolutionState evolutionState, Parameter parameter, GEPSpecies gEPSpecies) {
        this.parsedGeneExpressions = null;
        this.genome = new int[gEPSpecies.numberOfGenes][];
        int n = 0;
        while (n < gEPSpecies.numberOfGenes) {
            this.genome[n] = new int[gEPSpecies.geneSize];
            ++n;
        }
        if (gEPSpecies.useConstants) {
            this.genomeDc = new int[gEPSpecies.numberOfGenes][];
            n = 0;
            while (n < gEPSpecies.numberOfGenes) {
                this.genomeDc[n] = new int[gEPSpecies.tailSize];
                ++n;
            }
            this.genomeConstants = new double[gEPSpecies.numberOfGenes][];
            n = 0;
            while (n < gEPSpecies.numberOfGenes) {
                this.genomeConstants[n] = new double[gEPSpecies.numberOfConstantsPerGene];
                ++n;
            }
        } else {
            this.genomeDc = null;
            this.genomeConstants = null;
        }
    }

    public double getRandomFromLowerToUpper(MersenneTwisterFast mersenneTwisterFast, double d, double d2) {
        double d3 = mersenneTwisterFast.nextDouble();
        return d + d3 * (d2 - d);
    }

    public void reset(EvolutionState evolutionState, int n) {
        int n2;
        Object object;
        Object object2;
        GEPSpecies gEPSpecies = (GEPSpecies)this.myGEPIndividual.species;
        int n3 = 0;
        while (n3 < this.genome.length) {
            object2 = this.genome[n3];
            object = gEPSpecies.symbolSet;
            object2[0] = ((GEPSymbolSet)object).chooseFunctionSymbol(evolutionState, n);
            n2 = 1;
            while (n2 < ((int[])object2).length) {
                object2[n2] = ((GEPSymbolSet)object).chooseFunctionOrTerminalSymbol(evolutionState, n, n2, gEPSpecies);
                ++n2;
            }
            ++n3;
        }
        if (gEPSpecies.useConstants) {
            object2 = evolutionState.random[n];
            n3 = 0;
            while (n3 < this.genome.length) {
                object = this.genomeConstants[n3];
                int[] nArray = this.genomeDc[n3];
                int n4 = ((Object)object).length;
                if (gEPSpecies.integerConstants) {
                    int n5 = (int)(gEPSpecies.constantsUpperLimit - gEPSpecies.constantsLowerLimit + 1.0);
                    n2 = 0;
                    while (n2 < n4) {
                        object[n2] = (double)((MersenneTwisterFast)object2).nextInt(n5) + gEPSpecies.constantsLowerLimit;
                        ++n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n4) {
                        object[n2] = this.getRandomFromLowerToUpper((MersenneTwisterFast)object2, gEPSpecies.constantsLowerLimit, gEPSpecies.constantsUpperLimit);
                        ++n2;
                    }
                }
                n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = ((MersenneTwisterFast)object2).nextInt(n4);
                    ++n2;
                }
                ++n3;
            }
        }
        this.parsedGeneExpressions = null;
    }

    public String genotypeToStringForHumans() {
        String string = "Linking function: " + ((GEPSpecies)this.myGEPIndividual.species).linkingFunctionName + "\n";
        string = String.valueOf(string) + this.genotypeToStringForHumansKarva();
        string = String.valueOf(string) + "\n" + this.genotypeToStringForHumansMathExpression();
        string = String.valueOf(string) + "\n";
        return string;
    }

    public String genotypeToStringForHumansKarva() {
        try {
            String string = "";
            int n = 0;
            while (n < this.genome.length) {
                string = String.valueOf(string) + "Gene " + n + "\n";
                int n2 = 0;
                GEPSpecies gEPSpecies = (GEPSpecies)this.myGEPIndividual.species;
                int n3 = 0;
                while (n3 < this.genome[n].length) {
                    GEPSymbol gEPSymbol = gEPSpecies.symbolSet.symbols[this.genome[n][n3]];
                    String string2 = gEPSymbol instanceof GEPConstantTerminalSymbol ? "C" + (n2 < this.genomeDc[n].length ? String.valueOf(this.genomeDc[n][n2++]) : "?") : gEPSymbol.symbol;
                    string = String.valueOf(string) + (n3 == 0 ? "" : ".") + string2;
                    ++n3;
                }
                if (gEPSpecies.useConstants) {
                    string = String.valueOf(string) + "\n";
                    n3 = 0;
                    while (n3 < this.genomeConstants[n].length) {
                        string = String.valueOf(string) + "C" + n3 + ": " + this.genomeConstants[n][n3] + "\n";
                        ++n3;
                    }
                } else {
                    string = String.valueOf(string) + "\n";
                }
                ++n;
            }
            return string;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return "";
        }
    }

    public String genotypeToStringForHumansMathExpression() {
        String string = "";
        if (this.parsedGeneExpressions == null) {
            this.parseGenes();
        }
        int n = this.parsedGeneExpressions.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.nodeToStringMathExpr(this.parsedGeneExpressions[n2]);
            ++n2;
        }
        string = stringArray[0];
        GEPSpecies gEPSpecies = (GEPSpecies)this.myGEPIndividual.species;
        GEPFunctionSymbol gEPFunctionSymbol = gEPSpecies.linkingFunctionSymbol;
        int n3 = gEPFunctionSymbol.arity;
        String[] stringArray2 = new String[n3];
        int n4 = 1;
        while (n4 < n) {
            stringArray2[0] = string;
            int n5 = 1;
            while (n5 < n3) {
                stringArray2[n5] = stringArray[n4++];
                ++n5;
            }
            string = gEPFunctionSymbol.getMathExpressionAsString(stringArray2);
        }
        return string;
    }

    private String nodeToStringMathExpr(GEPExpressionTreeNode gEPExpressionTreeNode) {
        if (gEPExpressionTreeNode.isConstantNode) {
            if (gEPExpressionTreeNode.constantValue < 0.0) {
                return "(" + Double.toString(gEPExpressionTreeNode.constantValue) + ")";
            }
            return Double.toString(gEPExpressionTreeNode.constantValue);
        }
        if (gEPExpressionTreeNode.symbol instanceof GEPTerminalSymbol) {
            GEPTerminalSymbol gEPTerminalSymbol = (GEPTerminalSymbol)gEPExpressionTreeNode.symbol;
            return gEPTerminalSymbol.symbol;
        }
        GEPFunctionSymbol gEPFunctionSymbol = (GEPFunctionSymbol)gEPExpressionTreeNode.symbol;
        if (gEPFunctionSymbol.arity == 0) {
            return gEPFunctionSymbol.symbol;
        }
        int n = gEPExpressionTreeNode.numParameters;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < gEPExpressionTreeNode.numParameters) {
            stringArray[n2] = this.nodeToStringMathExpr(gEPExpressionTreeNode.parameters[n2]);
            ++n2;
        }
        String string = gEPFunctionSymbol.getMathExpressionAsString(stringArray);
        return string;
    }

    public String genotypeToString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Code.encode(this.genome.length));
        stringBuffer.append(Code.encode(this.genome[0].length));
        int n2 = 0;
        while (n2 < this.genome.length) {
            n = 0;
            while (n < this.genome[n2].length) {
                stringBuffer.append(Code.encode(this.genome[n2][n]));
                ++n;
            }
            ++n2;
        }
        stringBuffer.append(Code.encode(this.genomeDc.length));
        stringBuffer.append(Code.encode(this.genomeDc[0].length));
        n2 = 0;
        while (n2 < this.genomeDc.length) {
            n = 0;
            while (n < this.genomeDc[n2].length) {
                stringBuffer.append(Code.encode(this.genomeDc[n2][n]));
                ++n;
            }
            ++n2;
        }
        stringBuffer.append(Code.encode(this.genomeConstants.length));
        stringBuffer.append(Code.encode(this.genomeConstants[0].length));
        n2 = 0;
        while (n2 < this.genomeConstants.length) {
            n = 0;
            while (n < this.genomeConstants[n2].length) {
                stringBuffer.append(Code.encode(this.genomeConstants[n2][n]));
                ++n;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void parseGenotype(EvolutionState evolutionState, LineNumberReader lineNumberReader) throws IOException {
        int n;
        String string = lineNumberReader.readLine();
        DecodeReturn decodeReturn = new DecodeReturn(string);
        Code.decode(decodeReturn);
        int n2 = (int)decodeReturn.l;
        Code.decode(decodeReturn);
        int n3 = (int)decodeReturn.l;
        this.genome = new int[n2][n3];
        int n4 = 0;
        while (n4 < this.genome.length) {
            n = 0;
            while (n < this.genome[n4].length) {
                Code.decode(decodeReturn);
                this.genome[n4][n] = (int)decodeReturn.l;
                ++n;
            }
            ++n4;
        }
        n2 = (int)decodeReturn.l;
        Code.decode(decodeReturn);
        n3 = (int)decodeReturn.l;
        this.genomeDc = new int[n2][n3];
        n4 = 0;
        while (n4 < this.genomeDc.length) {
            n = 0;
            while (n < this.genomeDc[n4].length) {
                Code.decode(decodeReturn);
                this.genomeDc[n4][n] = (int)decodeReturn.l;
                ++n;
            }
            ++n4;
        }
        n2 = (int)decodeReturn.l;
        Code.decode(decodeReturn);
        n3 = (int)decodeReturn.l;
        this.genomeConstants = new double[n2][n3];
        n4 = 0;
        while (n4 < this.genomeConstants.length) {
            n = 0;
            while (n < this.genomeConstants[n4].length) {
                Code.decode(decodeReturn);
                this.genomeConstants[n4][n] = decodeReturn.l;
                ++n;
            }
            ++n4;
        }
    }

    public void writeGenotype(EvolutionState evolutionState, DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeInt(this.genome.length);
        dataOutput.writeInt(this.genome[0].length);
        int n2 = 0;
        while (n2 < this.genome.length) {
            n = 0;
            while (n < this.genome[n2].length) {
                dataOutput.writeInt(this.genome[n2][n]);
                ++n;
            }
            ++n2;
        }
        dataOutput.writeInt(this.genomeDc.length);
        dataOutput.writeInt(this.genomeDc[0].length);
        n2 = 0;
        while (n2 < this.genomeDc.length) {
            n = 0;
            while (n < this.genomeDc[n2].length) {
                dataOutput.writeInt(this.genomeDc[n2][n]);
                ++n;
            }
            ++n2;
        }
        dataOutput.writeInt(this.genomeConstants.length);
        dataOutput.writeInt(this.genomeConstants[0].length);
        n2 = 0;
        while (n2 < this.genomeConstants.length) {
            n = 0;
            while (n < this.genomeConstants[n2].length) {
                dataOutput.writeDouble(this.genomeConstants[n2][n]);
                ++n;
            }
            ++n2;
        }
    }

    public void readGenotype(EvolutionState evolutionState, DataInput dataInput) throws IOException {
        int n;
        int n2;
        int n3 = dataInput.readInt();
        int n4 = dataInput.readInt();
        if (this.genome == null || this.genome.length != n3 || this.genome[0].length != n4) {
            this.genome = new int[n3][n4];
        }
        int n5 = 0;
        while (n5 < this.genome.length) {
            n2 = 0;
            while (n2 < this.genome[n5].length) {
                this.genome[n5][n2] = dataInput.readInt();
                ++n2;
            }
            ++n5;
        }
        n5 = dataInput.readInt();
        n2 = dataInput.readInt();
        if (this.genomeDc == null || this.genomeDc.length != n5 || this.genomeDc[0].length != n2) {
            this.genomeDc = new int[n5][n2];
        }
        int n6 = 0;
        while (n6 < this.genomeDc.length) {
            n = 0;
            while (n < this.genomeDc[n6].length) {
                this.genomeDc[n6][n] = dataInput.readInt();
                ++n;
            }
            ++n6;
        }
        n6 = dataInput.readInt();
        n = dataInput.readInt();
        if (this.genomeConstants == null || this.genomeConstants.length != n6 || this.genomeConstants[0].length != n) {
            this.genomeConstants = new double[n6][n];
        }
        int n7 = 0;
        while (n7 < this.genomeConstants.length) {
            int n8 = 0;
            while (n8 < this.genomeConstants[n7].length) {
                this.genomeConstants[n7][n8] = dataInput.readDouble();
                ++n8;
            }
            ++n7;
        }
    }

    public Object clone() {
        try {
            int n;
            GEPChromosome gEPChromosome = (GEPChromosome)super.clone();
            gEPChromosome.genome = new int[this.genome.length][];
            int n2 = 0;
            while (n2 < this.genome.length) {
                gEPChromosome.genome[n2] = new int[this.genome[n2].length];
                n = 0;
                while (n < this.genome[n2].length) {
                    gEPChromosome.genome[n2][n] = this.genome[n2][n];
                    ++n;
                }
                ++n2;
            }
            if (this.genomeConstants != null) {
                gEPChromosome.genomeConstants = new double[this.genomeConstants.length][];
                gEPChromosome.genomeDc = new int[this.genomeDc.length][];
                n2 = 0;
                while (n2 < this.genome.length) {
                    gEPChromosome.genomeDc[n2] = new int[this.genomeDc[n2].length];
                    n = 0;
                    while (n < this.genomeDc[n2].length) {
                        gEPChromosome.genomeDc[n2][n] = this.genomeDc[n2][n];
                        ++n;
                    }
                    gEPChromosome.genomeConstants[n2] = new double[this.genomeConstants[n2].length];
                    n = 0;
                    while (n < this.genomeConstants[n2].length) {
                        gEPChromosome.genomeConstants[n2][n] = this.genomeConstants[n2][n];
                        ++n;
                    }
                    ++n2;
                }
            } else {
                gEPChromosome.genomeConstants = null;
                gEPChromosome.genomeDc = null;
            }
            if (this.parsedGeneExpressions == null) {
                gEPChromosome.parsedGeneExpressions = null;
            } else {
                gEPChromosome.parsedGeneExpressions = new GEPExpressionTreeNode[this.parsedGeneExpressions.length];
                n2 = 0;
                while (n2 < this.parsedGeneExpressions.length) {
                    gEPChromosome.parsedGeneExpressions[n2] = (GEPExpressionTreeNode)this.parsedGeneExpressions[n2].clone();
                    ++n2;
                }
            }
            return gEPChromosome;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void parseGenes() {
        GEPSpecies gEPSpecies = (GEPSpecies)this.myGEPIndividual.species;
        boolean bl = gEPSpecies.useConstants;
        this.parsedGeneExpressions = new GEPExpressionTreeNode[this.genome.length];
        int n = 0;
        while (n < this.genome.length) {
            this.parsedGeneExpressions[n] = bl ? this.parseGeneWithConstants(this.genome[n], this.genomeDc[n], this.genomeConstants[n], gEPSpecies.symbolSet) : this.parseGene(this.genome[n], gEPSpecies.symbolSet);
            ++n;
        }
    }

    public GEPExpressionTreeNode parseGene(int[] nArray, GEPSymbolSet gEPSymbolSet) {
        LinkedList<GEPExpressionTreeNode> linkedList = new LinkedList<GEPExpressionTreeNode>();
        LinkedList<GEPExpressionTreeNode> linkedList2 = new LinkedList<GEPExpressionTreeNode>();
        GEPSymbol[] gEPSymbolArray = gEPSymbolSet.symbols;
        int n = 0;
        int n2 = nArray[n++];
        GEPSymbol gEPSymbol = gEPSymbolArray[n2];
        GEPExpressionTreeNode gEPExpressionTreeNode = new GEPExpressionTreeNode(gEPSymbol);
        int n3 = 0;
        while (n3 < gEPSymbol.arity) {
            linkedList.addLast(new GEPExpressionTreeNode(gEPSymbolArray[nArray[n++]]));
            linkedList2.addLast(gEPExpressionTreeNode);
            ++n3;
        }
        while (!linkedList.isEmpty()) {
            GEPExpressionTreeNode gEPExpressionTreeNode2 = (GEPExpressionTreeNode)linkedList.removeFirst();
            GEPExpressionTreeNode gEPExpressionTreeNode3 = (GEPExpressionTreeNode)linkedList2.removeFirst();
            gEPExpressionTreeNode3.addParameter(gEPExpressionTreeNode2);
            int n4 = gEPExpressionTreeNode2.symbol.arity;
            n3 = 0;
            while (n3 < n4) {
                linkedList.addLast(new GEPExpressionTreeNode(gEPSymbolArray[nArray[n++]]));
                linkedList2.addLast(gEPExpressionTreeNode2);
                ++n3;
            }
        }
        return gEPExpressionTreeNode;
    }

    public GEPExpressionTreeNode parseGeneWithConstants(int[] nArray, int[] nArray2, double[] dArray, GEPSymbolSet gEPSymbolSet) {
        GEPSymbol gEPSymbol;
        int n;
        GEPSymbol gEPSymbol2;
        LinkedList<GEPExpressionTreeNode> linkedList = new LinkedList<GEPExpressionTreeNode>();
        LinkedList<GEPExpressionTreeNode> linkedList2 = new LinkedList<GEPExpressionTreeNode>();
        GEPSymbol[] gEPSymbolArray = gEPSymbolSet.symbols;
        int n2 = 0;
        int n3 = 0;
        GEPExpressionTreeNode gEPExpressionTreeNode = (gEPSymbol2 = gEPSymbolArray[n = nArray[n2++]]) instanceof GEPConstantTerminalSymbol ? new GEPExpressionTreeNode(gEPSymbol2, dArray[nArray2[n3++]]) : new GEPExpressionTreeNode(gEPSymbol2);
        int n4 = 0;
        while (n4 < gEPSymbol2.arity) {
            if ((gEPSymbol = gEPSymbolArray[nArray[n2++]]) instanceof GEPConstantTerminalSymbol) {
                linkedList.addLast(new GEPExpressionTreeNode(gEPSymbol, dArray[nArray2[n3++]]));
            } else {
                linkedList.addLast(new GEPExpressionTreeNode(gEPSymbol));
            }
            linkedList2.addLast(gEPExpressionTreeNode);
            ++n4;
        }
        while (!linkedList.isEmpty()) {
            GEPExpressionTreeNode gEPExpressionTreeNode2 = (GEPExpressionTreeNode)linkedList.removeFirst();
            GEPExpressionTreeNode gEPExpressionTreeNode3 = (GEPExpressionTreeNode)linkedList2.removeFirst();
            gEPExpressionTreeNode3.addParameter(gEPExpressionTreeNode2);
            int n5 = gEPExpressionTreeNode2.symbol.arity;
            n4 = 0;
            while (n4 < n5) {
                if ((gEPSymbol = gEPSymbolArray[nArray[n2++]]) instanceof GEPConstantTerminalSymbol) {
                    linkedList.addLast(new GEPExpressionTreeNode(gEPSymbol, dArray[nArray2[n3++]]));
                } else {
                    linkedList.addLast(new GEPExpressionTreeNode(gEPSymbol));
                }
                linkedList2.addLast(gEPExpressionTreeNode2);
                ++n4;
            }
        }
        return gEPExpressionTreeNode;
    }

    public double eval(boolean bl, int n) {
        double d;
        if (this.parsedGeneExpressions == null) {
            this.parseGenes();
        }
        if (Double.isNaN(d = this.parsedGeneExpressions[0].eval(bl, n))) {
            return d;
        }
        if (this.genome.length == 1) {
            return d;
        }
        GEPSpecies gEPSpecies = (GEPSpecies)this.myGEPIndividual.species;
        GEPFunctionSymbol gEPFunctionSymbol = gEPSpecies.linkingFunctionSymbol;
        int n2 = gEPFunctionSymbol.arity;
        double[] dArray = new double[n2];
        int n3 = 1;
        while (n3 < this.genome.length) {
            dArray[0] = d;
            int n4 = 1;
            while (n4 < n2) {
                dArray[n4] = this.parsedGeneExpressions[n3++].eval(bl, n);
                ++n4;
            }
            d = gEPFunctionSymbol.eval(dArray);
            if (!Double.isNaN(d)) continue;
            return d;
        }
        if (GEPIndividual.isThresholdON()) {
            d = d >= GEPIndividual.getThreshold() ? 1 : 0;
        }
        return d;
    }

    public long size() {
        long l = 0L;
        if (this.parsedGeneExpressions == null) {
            this.parseGenes();
        }
        int n = 0;
        while (n < this.parsedGeneExpressions.length) {
            l += (long)this.parsedGeneExpressions[n].numberOfNodes();
            ++n;
        }
        return l;
    }

    public int[] variableUseageCounts() {
        GEPSpecies gEPSpecies = (GEPSpecies)this.myGEPIndividual.species;
        int[] nArray = new int[gEPSpecies.symbolSet.numberOfTerminals];
        if (this.parsedGeneExpressions == null) {
            this.parseGenes();
        }
        int n = 0;
        while (n < this.parsedGeneExpressions.length) {
            this.parsedGeneExpressions[n].variableUseageCounts(nArray);
            ++n;
        }
        return nArray;
    }

    public HashMap functionUseageCounts() {
        HashMap hashMap = new HashMap();
        if (this.parsedGeneExpressions == null) {
            this.parseGenes();
        }
        int n = 0;
        while (n < this.parsedGeneExpressions.length) {
            this.parsedGeneExpressions[n].functionUseageCounts(hashMap);
            ++n;
        }
        return hashMap;
    }
}

